<?php
/**
 * Enable Settings In Menu Module
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_menu_module_settings')) {
    function pac_drh_enable_menu_module_settings()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_menu_module_settings', 'off');
    }
}
/**
 * Add Text Beside Hamburger Menu Icon
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_hamburger_menu_text')) {
    function pac_drh_enable_hamburger_menu_text()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_hamburger_menu_text', 'off');
    }
}
/**
 * Hamburger Menu Text
 *
 * @return array|false|mixed|string|void
 */
if (!function_exists('pac_drh_hamburger_header_menu_text')) {
    function pac_drh_hamburger_header_menu_text()
    {
        return pac_drh_get_option('pac_drh_hamburger_header_menu_text', 'Menu');
    }
}
/**
 * Show A Hamburger Menu On Desktop
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_hamburger_menu_desktop')) {
    function pac_drh_enable_hamburger_menu_desktop()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_hamburger_menu_desktop', 'off');
    }
}
/**
 * Collapse Mobile Menu Submenus
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_collapse_mobile_submenus')) {
    function pac_drh_enable_collapse_mobile_submenus()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_collapse_mobile_submenus', 'off');
    }
}
/**
 * Collapse Other Submenus
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_collapse_other_submenus')) {
    function pac_drh_enable_collapse_other_submenus()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_collapse_other_submenus', 'off');
    }
}
/**
 * Open/Close Submenus By Clicking Parent Menu Item
 *
 * @return bool
 */
if (!function_exists('pac_drh_openclose_submenu_with_parent')) {
    function pac_drh_openclose_submenu_with_parent()
    {
        return 'on' === pac_drh_get_option('pac_drh_openclose_submenu_with_parent', 'off');
    }
}
/**
 * Custom Gutter Width
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_custom_gutter_width')) {
    function pac_drh_enable_custom_gutter_width()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_custom_gutter_width', 'off');
    }
}
/**
 * Fixed Navigation Bar
 *
 * @return bool
 */
if (!function_exists('pac_drh_fixed_navigation_bar')) {
    function pac_drh_fixed_navigation_bar()
    {
        return 'on' === pac_drh_get_option('pac_drh_fixed_navigation_bar', 'off');
    }
}
/**
 * Show X Icon When Opened
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_open_mobile_icon')) {
    function pac_drh_enable_open_mobile_icon()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_open_mobile_icon', 'off');
    }
}
/**
 * Menu Breakpoint
 *
 * @return array|false|mixed|string|void
 */
if (!function_exists('pac_drh_menu_breakpoint')) {
    function pac_drh_menu_breakpoint()
    {
        return pac_drh_get_option('pac_drh_menu_breakpoint');
    }
}
/**
 * Prevent Horizontal Scroll
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_prevent_horizontal_scroll')) {
    function pac_drh_enable_prevent_horizontal_scroll()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_prevent_horizontal_scroll', 'off');
    }
}
/**
 * Disable Animations On Mobile
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_remove_animation')) {
    function pac_drh_enable_remove_animation()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_remove_animation', 'off');
    }
}
/**
 * Back To Top Button Visibility
 *
 * @return array|false|mixed|string|void
 */
if (!function_exists('pac_drh_back_top_visibility')) {
    function pac_drh_back_top_visibility()
    {
        return pac_drh_get_option('pac_drh_back_top_visibility', 'off');
    }
}
/**
 * Mobile Logo
 *
 * @return array|false|mixed|string|void
 */
if (!function_exists('pac_drh_mobile_logo')) {
    function pac_drh_mobile_logo()
    {
        return pac_drh_get_option('pac_drh_mobile_logo');
    }
}
/**
 * Mobile Header Bar Color
 *
 * @return array|false|mixed|string|void
 */
if (!function_exists('pac_drh_mobile_header_color')) {
    function pac_drh_mobile_header_color()
    {
        return pac_drh_get_option('pac_drh_mobile_header_color');
    }
}
/**
 * Mobile Pinch Zooming
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_mobile_pinch_zoom')) {
    function pac_drh_enable_mobile_pinch_zoom()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_mobile_pinch_zoom', 'off');
    }
}
/**
 * Disable Hover Effects On Touch Devices
 *
 * @return bool
 */
if (!function_exists('pac_drh_disabled_hover_effects')) {
    function pac_drh_disabled_hover_effects()
    {
        return 'on' === pac_drh_get_option('pac_drh_disabled_hover_effects', 'off');
    }
}
/**
 * Disable Divi Responsive Views Settings
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_hide_responsive_view')) {
    function pac_drh_enable_hide_responsive_view()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_hide_responsive_view', 'off');
    }
}
/**
 * Enable View Port Size
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_view_port_size')) {
    function pac_drh_enable_view_port_size()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_view_port_size', 'off');
    }
}
/**
 * Preview Size Presets
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_presets')) {
    function pac_drh_enable_presets()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_presets', 'off');
    }
}
/**
 * Preview Size Custom Value
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_custom_preview')) {
    function pac_drh_enable_custom_preview()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_custom_preview', 'off');
    }
}
/**
 * Widow Fixer
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_widow_fixer')) {
    function pac_drh_enable_widow_fixer()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_widow_fixer', 'off');
    }
}
/**
 * Row Column Stacking Order
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_col_stacking')) {
    function pac_drh_enable_col_stacking()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_col_stacking', 'off');
    }
}
/**
 * Row Number of Columns
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_number_of_columns')) {
    function pac_drh_enable_number_of_columns()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_number_of_columns', 'off');
    }
}
/**
 * Blog Module Number of Columns
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_blog_number_of_columns')) {
    function pac_drh_enable_blog_number_of_columns()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_blog_number_of_columns', 'off');
    }
}
/**
 * Portfolio Modules Number of Columns
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_portfolio_number_of_columns')) {
    function pac_drh_enable_portfolio_number_of_columns()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_portfolio_number_of_columns', 'off');
    }
}
/**
 * Gallery Module Number of Columns
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_gallery_number_of_columns')) {
    function pac_drh_enable_gallery_number_of_columns()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_gallery_number_of_columns', 'off');
    }
}
/**
 * Woo Products Module Number of Columns
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_shop_number_of_columns')) {
    function pac_drh_enable_shop_number_of_columns()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_shop_number_of_columns', 'off');
    }
}
/**
 * Woo Related Products Module Number of Columns
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_related_products_number_of_columns')) {
    function pac_drh_enable_related_products_number_of_columns()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_related_products_number_of_columns', 'off');
    }
}
/**
 * Woo CrossSells Products Module Number of Columns
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_crosssells_number_of_columns')) {
    function pac_drh_enable_crosssells_number_of_columns()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_crosssells_number_of_columns', 'off');
    }
}
/**
 * Woo UpSells Products Module Number of Columns
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_upsells_number_of_columns')) {
    function pac_drh_enable_upsells_number_of_columns()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_upsells_number_of_columns', 'off');
    }
}
/**
 * Parallax On Mobile Devices
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_mobile_parallax')) {
    function pac_drh_enable_mobile_parallax()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_mobile_parallax', 'off');
    }
}
/**
 * Blurb Image/Icon Position On Phone
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_blurb_settings')) {
    function pac_drh_enable_blurb_settings()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_blurb_settings', 'off');
    }
}
/**
 * Tabs Module Tab Layout
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_tabs_layout_settings')) {
    function pac_drh_enable_tabs_layout_settings()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_tabs_layout_settings', 'off');
    }
}
/**
 * Text Sizes
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_text_sizes')) {
    function pac_drh_enable_text_sizes()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_text_sizes', 'off');
    }
}
/**
 * Show/Hide Menu Items Per Device
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_show_hide_menu_item')) {
    function pac_drh_enable_show_hide_menu_item()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_show_hide_menu_item', 'off');
    }
}
/**
 * Number Of Posts In Blog Module
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_responsive_blog_count')) {
    function pac_drh_enable_responsive_blog_count()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_responsive_blog_count', 'off');
    }
}
/**
 * Number Of Products In Woo Module
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_responsive_shop_count')) {
    function pac_drh_enable_responsive_shop_count()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_responsive_shop_count', 'off');
    }
}
/**
 * Number Of Images In Gallery Module
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_responsive_gallery_count')) {
    function pac_drh_enable_responsive_gallery_count()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_responsive_gallery_count', 'off');
    }
}
/**
 * Number Of Portfolio Project Count
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_responsive_portfolio_count')) {
    function pac_drh_enable_responsive_portfolio_count()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_responsive_portfolio_count', 'off');
    }
}
/**
 * Auto Open Responsive Tabs
 *
 * @return bool
 */
if (!function_exists('pac_drh_enable_auto_responsive')) {
    function pac_drh_enable_auto_responsive()
    {
        return 'on' === pac_drh_get_option('pac_drh_enable_auto_responsive', 'off');
    }
}
/**
 * Custom Presets
 *
 * @return array
 */
if (!function_exists('pac_drh_custom_presets')) {
    function pac_drh_custom_presets()
    {
        return [
            'pac_drh_phone_preset_one' => pac_drh_get_option('pac_drh_phone_preset_one', '320'),
            'pac_drh_phone_preset_two' => pac_drh_get_option('pac_drh_phone_preset_two', '479'),
            'pac_drh_phone_preset_three' => pac_drh_get_option('pac_drh_phone_preset_three', '767'),
            'pac_drh_tablet_preset_one' => pac_drh_get_option('pac_drh_tablet_preset_one', '768'),
            'pac_drh_tablet_preset_two' => pac_drh_get_option('pac_drh_tablet_preset_two', '880'),
            'pac_drh_tablet_preset_three' => pac_drh_get_option('pac_drh_tablet_preset_three', '980'),
            'pac_drh_desktop_preset_one' => pac_drh_get_option('pac_drh_desktop_preset_one', '982'),
            'pac_drh_desktop_preset_two' => pac_drh_get_option('pac_drh_desktop_preset_two', '1024'),
            'pac_drh_desktop_preset_three' => pac_drh_get_option('pac_drh_desktop_preset_three', '1200'),
        ];
    }
}


