<?php
/**
 * Get Option
 *
 * @param $option_name
 * @param $default
 *
 * @return array|false|mixed|string|void
 * @since 2.3
 */
if (!function_exists('pac_drh_get_option')) {
    function pac_drh_get_option($option_name, $default = null)
    {
        if (function_exists('et_get_option')) {
            return et_get_option($option_name);
        } elseif (function_exists('get_option')) {
            $options = get_option('et_divi');
            if (isset($options[$option_name])) {
                return $options[$option_name];
            }
        }

        return $default;
    }
}

/**
 * Instance Detect Mobile Class
 * @return Mobile_Detect|null
 */

use lib\PAC_DRH\Mobile_Detect;

if (!function_exists('pac_drh_detect_mobile')) {

    function pac_drh_detect_mobile()
    {
        static $instance = null;
        if (null === $instance) {
            $instance = new Mobile_Detect();
        }

        return $instance;
    }
}
/**
 * Get Min
 * @return string
 */
if (!function_exists('pac_drh_minify')) {
    function pac_drh_minify()
    {
        $min = '.min';
        if (defined('WP_DEBUG') && true === WP_DEBUG) {
            $min = '';
        }

        return $min;
    }
}
/**
 * Get Media Queries
 * @return string[]
 */
if (!function_exists('pac_drh_custom_media_queries')) {
    function pac_drh_custom_media_queries()
    {
        return [
            'one',
            'two',
            'three',
            'four',
            'five',
        ];
    }
}
/**
 * Get Color Scheme Color
 * @return string
 * @since 2.2
 */
if (!function_exists('pac_drh_get_color_scheme')) {
    function pac_drh_get_color_scheme()
    {
        $color_schemes = et_get_option('color_schemes', 'none');
        switch ($color_schemes) {
            case 'green':
                $color = "#7cc68d";
                break;
            case 'orange':
                $color = "#edb059";
                break;
            case 'pink':
                $color = "#c37cc6";
                break;
            case 'red':
                $color = "#cd5c5c";
                break;
            default:
                $color = et_get_option('accent_color', '#2ea3f2');
        }

        return $color;
    }
}
/**
 * Wordpress Pages List
 * @return array
 */
if (!function_exists('pac_drh_get_pages_list')) {
    function pac_drh_get_pages_list()
    {
        $pages_ids = [];
        $pages = get_pages('hide_empty=0');
        if (!empty($pages)) {
            foreach ($pages as $page) {
                $pages_ids[] = $page->ID;
            }
        }

        return array_map('intval', $pages_ids);
    }
}
/**
 * Check Is POST PAGE
 * @return bool
 */
if (!function_exists('pac_drh_is_post_page')) {
    function pac_drh_is_post_page()
    {
        global $pagenow;
        if ('post.php' === $pagenow) {
            return true;
        }

        return false;
    }
}
// phpcs:disable
/**
 * Log data
 *
 * @param $message
 * @param false $delete
 * @param string $file_name
 */
if (!function_exists('pac_drh_log')) :
    function pac_drh_log($message, $delete = false, $filename = '')
    {
        $filename = empty($filename) ? debug_backtrace()[1]['function'] : $filename;
        $filename = WP_CONTENT_DIR.DIRECTORY_SEPARATOR.$filename.'.log';
        if (file_exists($filename) && $delete) {
            wp_delete_file($filename);
        }
        ini_set('error_log', $filename);
        if (is_array($message) || is_object($message)) {
            error_log(print_r($message, true));
        } else {
            error_log($message);
        }
    }
endif;
/**
 * Print Data
 *
 * @param string $data
 * @param bool $console
 * @param bool $exit
 */
if (!function_exists('pac_drh_dd')) {

    function pac_drh_dd($data = '', $console = true, $exit = true)
    {
        if ($console) {
            echo '<script type="text/javascript">';
            echo 'console.log('.wp_json_encode($data).')';
            echo '</script>';
        } else {
            echo "<pre>";
            print_r($data);
            echo "</pre>";
            echo $exit ? exit : null;
        }
    }
}
// phpcs:enable