jQuery(document).ready(function ($) {
    var userAgent = null !== navigator.userAgent.match(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/);
    var viewPort;
    if (userAgent) {
        viewPort = function (elem) {
            let elementTop = elem.offset().top, elementBottom = elementTop + elem.outerHeight(),
                viewportTop = $(window).scrollTop(), viewportBottom = viewportTop + $(window).height();
            return elementBottom > viewportTop && elementTop < viewportBottom;
        };
        //  mobileParallax();
        $(window).scroll(mobileParallax);
    }

    function mobileParallax() {
        var isParallax = ".et_parallax_bg_wrap .et_parallax_bg";
        if ($(isParallax).length > 0) {
            $(isParallax).addClass('pac_drh_parallax')
            $('.pac_drh_parallax').each(function () {
                var $this = $(this);
                var $thisParent = $this.parent();
                if (viewPort($thisParent)) {
                    var offsetTop = $thisParent.offset().top;
                    var parallaxHeight = $this.parent(".et_pb_fullscreen").length && $(window).height() > $thisParent.innerHeight() ? $(window).height() : $thisParent.innerHeight();
                    var height = .3 * $(window).height() + parallaxHeight;
                    var transform = "translate(0, " + .3 * ($(window).scrollTop() + $(window).height() - offsetTop) + "px)";
                    $('.pac_drh_parallax').css({
                        'height': height,
                        '-webkit-transform': transform,
                        '-moz-transform': transform,
                        '-ms-transform': transform,
                        'transform': transform,
                    });
                }
            });
        }
    }
});
