jQuery(document).ready(function ($) {
    let userAgent = null !== navigator.userAgent.match(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/);
    let viewPort;
    if (userAgent) {
        viewPort = function (elem) {
            elementTop = elem.offset().top, elementBottom = elementTop + elem.outerHeight(), viewportTop = $(window).scrollTop(), viewportBottom = viewportTop + $(window).height();
            return elementBottom > viewportTop && elementTop < viewportBottom;
        };
        mobileParallax();
        $(window).scroll(mobileParallax);
    }

    function mobileParallax() {
        // True Parallax
        let pacTrueParallax = ".et_parallax_bg";
        if ($(pacTrueParallax).length > 0) {
            $(pacTrueParallax).addClass('pac_drh_true_parallax')
            $('.pac_drh_true_parallax').each(function () {
                let pacDRHParent = $(this).parent();
                if (viewPort(pacDRHParent)) {
                    let pacDRHElementTop = pacDRHParent.offset().top;
                    pacDRHParallaxHeight = $(this).parent(".et_pb_fullscreen").length && $(window).height() > pacDRHParent.innerHeight() ? $(window).height() : pacDRHParent.innerHeight();
                    pacDRHHeight = .3 * $(window).height() + pacDRHParallaxHeight;
                    pacDRHTransform = "translate(0, " + .3 * ($(window).scrollTop() + $(window).height() - pacDRHElementTop) + "px)";
                    $('.pac_drh_true_parallax').css({
                        "background-position": "top !important;",
                        "-moz-background-size": "cover !important;",
                        "-webkit-background-size": "cover !important;",
                        "background-size": "cover !important;",
                        "overflow": "hidden !important;",
                        "height": pacDRHHeight,
                        "-webkit-transform": pacDRHTransform,
                        "-moz-transform": pacDRHTransform,
                        "-ms-transform": pacDRHTransform,
                        "transform": pacDRHTransform,
                    });
                }
            });
        }
        // CSS Parallax
        let isCssParallax = ".et_parallax_bg.et_pb_parallax_css";
        if ($(isCssParallax).length > 0) {
            $(isCssParallax).removeClass('pac_drh_true_parallax')
            $(isCssParallax).addClass('pac_drh_css_parallax')
            $('.pac_drh_css_parallax').each(function () {
                this.style.setProperty('background-attachment', 'fixed', 'important');
                this.style.setProperty('background-repeat', 'no-repeat', 'important');
                this.style.setProperty('background-position', 'center', 'important');
                this.style.setProperty('background-size', 'cover', 'important');
                this.style.setProperty('-moz-background-size', 'cover', 'important');
                this.style.setProperty('-webkit-background-size', 'cover', 'important');
                this.style.setProperty('overflow', 'hidden', 'important');
                this.style.setProperty('height', '100%', 'important');
                this.style.removeProperty('-webkit-transform');
                this.style.removeProperty('-moz-transform');
                this.style.removeProperty('-ms-transform');
                this.style.removeProperty('transform');
            });
        }
    }
});
