(function ($) {
    const htmlObj = $('html');
    $(document).ready(function () {
        // Add View Support Button
        var builderLoaded = false;
        var vpLabel = 'Viewport Size: ';
        jQuery(document).on('DOMNodeInserted', '.et-fb-page-settings-bar .et-fb-page-settings-bar__column.et-fb-page-settings-bar__column--left', function () {
            setTimeout(function () {
                if (!builderLoaded) {
                    let vpWidth = jQuery(window).width();
                    let vpHeight = jQuery(window).height();
                    let vpButton = '<div class="et-fb-button-group et-fb-button-group--elevate et-fb-button-group--inverse et-fb-button-group--builder-mode" style="position: relative; left: 10px; opacity: 1;">';
                    vpButton += '<button type="button" data-tip="Current Viewport Size" class="et-fb-button et-fb-button--inverse">';
                    vpButton += '<span id="pac-viewport-size">' + vpLabel + vpWidth + 'px  x ' + vpHeight + 'px </span>';
                    vpButton += '</button>';
                    vpButton += '</div>';
                    jQuery('.et-fb-page-settings-bar .et-fb-page-settings-bar__column.et-fb-page-settings-bar__column--left').append(vpButton)
                    builderLoaded = true;
                }
            }, 600);
        });
        // Frontend Observe
        if (jQuery('#et-fb-app').length > 0) {
            var vpFrontendObserver = new MutationObserver(function (mutations) {
                for (let mutation of mutations) {
                    if (mutation.type === 'attributes') {
                        var coreFrameEle = jQuery('.et-core-frame');
                        let vpWidth = Math.round(coreFrameEle.width());
                        let vpHeight = Math.round(coreFrameEle.height());
                        jQuery('.et-fb-page-settings-bar #pac-viewport-size').text(vpLabel + vpWidth + 'px x ' + vpHeight + 'px');
                    }
                }
            });
            vpFrontendObserver.observe(document.getElementById('et-fb-app'), {
                attributes: true,
                subtree: true,
                childList: true,
            });
        }
        // Backend Observe
        if (jQuery('#et-fb-app').length > 0) {
            var vpBackendObserver = new MutationObserver(function (mutations) {
                for (let mutation of mutations) {
                    if (mutation.type === 'attributes') {
                        setTimeout(function () {
                            var vpEle = $('body', window.parent.document).find('#pac-viewport-size');
                            let vpWidth = Math.round($('body', window.parent.document).find('iframe').contents().width());
                            let vpHeight = Math.round($('body', window.parent.document).find('iframe').contents().height());
                            vpEle.text(vpLabel + vpWidth + 'px x ' + vpHeight + 'px')
                        }, 200);
                    }
                }
            });
            vpBackendObserver.observe(document.getElementById('et-fb-app'), {
                attributes: true,
                subtree: true,
                childList: true,
            });
            vpBackendObserver.observe(htmlObj.get(0), {
                attributes: true,
                subtree: true,
            });
        }
    });
})(jQuery);