window.pac_drh_custom_width = '0';
(function ($) {
    'use strict';
    $(document).ready(function () {
        const htmlObj = $('html');
        const bodyObj = $('body');
        const iframeSelector = 'iframe';
        var isButtonsAdded = false;
        var customPresetSize = '';
        var customPresetVal = '';
        var activeColor = {"color": "rgb(112, 195, 169)"};
        var presetPreviewButton = '.pac_preset_preview_button';
        var previewSizeInputFiled = '.pac_set_preview_size_input_filed';

        function addPreviewButtons(size) {
            if (isButtonsAdded) {
                return;
            }
            isButtonsAdded = true;
            const settingsBarObj = $('.et-fb-page-settings-bar .et-fb-page-settings-bar__column.et-fb-page-settings-bar__column--left .et-fb-button-group:first-of-type');
            if ('phone' === size) {
                if ((pac_drh_custom_presets.pac_drh_phone_preset_one > 300) && (pac_drh_custom_presets.pac_drh_phone_preset_one < 768)) {
                    settingsBarObj.append(
                        `<button type="button" data-size="xs" class="et-fb-button et-fb-button--inverse et-fb-button--app-modal pac_preset_preview_button pac_preset">` +
                        pac_drh_custom_presets.pac_drh_phone_preset_one +
                        `</button>`
                    );
                }
                if ((pac_drh_custom_presets.pac_drh_phone_preset_two > 300) && (pac_drh_custom_presets.pac_drh_phone_preset_two < 768)) {
                    settingsBarObj.append(
                        `<button type="button" data-size="l" class="et-fb-button et-fb-button--inverse et-fb-button--app-modal pac_preset_preview_button pac_preset">` +
                        pac_drh_custom_presets.pac_drh_phone_preset_two +
                        `</button>`
                    );
                }
                if ((pac_drh_custom_presets.pac_drh_phone_preset_three > 300) && (pac_drh_custom_presets.pac_drh_phone_preset_three < 768)) {
                    settingsBarObj.append(
                        `<button type="button" data-size="xl" class="et-fb-button et-fb-button--inverse et-fb-button--app-modal pac_preset_preview_button pac_preset">` +
                        pac_drh_custom_presets.pac_drh_phone_preset_three +
                        `</button>`
                    );
                }
            } else if ('tablet' === size) {
                if ((pac_drh_custom_presets.pac_drh_tablet_preset_one > 767) && (pac_drh_custom_presets.pac_drh_tablet_preset_one < 982)) {
                    settingsBarObj.append(
                        `<button type="button" data-size="s" class="et-fb-button et-fb-button--inverse et-fb-button--app-modal pac_preset_preview_button pac_preset">` +
                        pac_drh_custom_presets.pac_drh_tablet_preset_one +
                        `</button>`
                    );
                }
                if ((pac_drh_custom_presets.pac_drh_tablet_preset_two > 767) && (pac_drh_custom_presets.pac_drh_tablet_preset_two < 982)) {
                    settingsBarObj.append(
                        `<button type="button" data-size="m" class="et-fb-button et-fb-button--inverse et-fb-button--app-modal pac_preset_preview_button pac_preset">` +
                        pac_drh_custom_presets.pac_drh_tablet_preset_two +
                        `</button>`
                    );
                }
                if ((pac_drh_custom_presets.pac_drh_tablet_preset_three > 767) && (pac_drh_custom_presets.pac_drh_tablet_preset_three < 982)) {
                    settingsBarObj.append(
                        `<button type="button" data-size="l" class="et-fb-button et-fb-button--inverse et-fb-button--app-modal pac_preset_preview_button pac_preset">` +
                        pac_drh_custom_presets.pac_drh_tablet_preset_three +
                        `</button>`
                    );
                }
            } else if ('desktop' === size) {
                if (pac_drh_custom_presets.pac_drh_desktop_preset_one > 980) {
                    settingsBarObj.append(
                        `<button type="button" data-size="s" class="et-fb-button et-fb-button--inverse et-fb-button--app-modal pac_preset_preview_button pac_preset">` +
                        pac_drh_custom_presets.pac_drh_desktop_preset_one +
                        `</button>`
                    );
                }
                if (pac_drh_custom_presets.pac_drh_desktop_preset_two > 980) {
                    settingsBarObj.append(
                        `<button type="button" data-size="m" class="et-fb-button et-fb-button--inverse et-fb-button--app-modal pac_preset_preview_button pac_preset">` +
                        pac_drh_custom_presets.pac_drh_desktop_preset_two +
                        `</button>`
                    );
                }
                if (pac_drh_custom_presets.pac_drh_desktop_preset_three > 980) {
                    settingsBarObj.append(
                        `<button type="button" data-size="l" class="et-fb-button et-fb-button--inverse et-fb-button--app-modal pac_preset_preview_button pac_preset">` +
                        pac_drh_custom_presets.pac_drh_desktop_preset_three +
                        `</button>`
                    );
                }
            }
            settingsBarObj.append(
                `<input type="text" data-size="custom" class="et-fb-button et-fb-button--inverse et-fb-button--app-modal pac_preset_preview_button pac_set_preview_size_input_filed" name="pac_preview_size" value="" placeholder="Enter Size" />`
            );
            // Set Preset Active
            if (typeof customPresetSize !== 'undefined') {
                $('button.pac_preset_preview_button[data-size="' + customPresetSize + '"]').css(activeColor);
            }
            // Set Preset Value
            if (typeof customPresetVal !== 'undefined' && '' !== customPresetVal) {
                $(previewSizeInputFiled).val(customPresetVal);
            }
        }

        function removePreviewButtons() {
            $(presetPreviewButton).remove();
            isButtonsAdded = false;
        }

        function isDesktopPreview() {
            if ($('#wpwrap').length > 0) {
                return $(iframeSelector).contents().find("html").hasClass("et-fb-preview--desktop") || $(iframeSelector).contents().find("html").hasClass('et_fb_preview_active--responsive_preview--desktop_preview');
            }
            return (htmlObj.hasClass('et_fb_preview_active--responsive_preview--desktop_preview') || htmlObj.hasClass('et-fb-preview--desktop'));
        }

        function isTabletPreview() {
            if ($('#wpwrap').length > 0) {
                return $(iframeSelector).contents().find("html").hasClass("et-fb-preview--tablet") || $(iframeSelector).contents().find("html").hasClass('et_fb_preview_active--responsive_preview--tablet_preview');
            }
            return (htmlObj.hasClass('et_fb_preview_active--responsive_preview--tablet_preview') || htmlObj.hasClass('et-fb-preview--tablet'));
        }

        function isPhonePreview() {
            if ($('#wpwrap').length > 0) {
                return $(iframeSelector).contents().find("html").hasClass("et-fb-preview--phone") || $(iframeSelector).contents().find("html").hasClass('et_fb_preview_active--responsive_preview--phone_preview');
            }
            return (htmlObj.hasClass('et_fb_preview_active--responsive_preview--phone_preview') || htmlObj.hasClass('et-fb-preview--phone'));
        }

        function isBackendBuilder() {
            if (jQuery('.et-bfb').length) {
                return true;
            } else {
                return false;
            }
        }

        // MutationObserver
        const MutationObserver = window.MutationObserver || window.WebKitMutationObserver;
        var mObserver = new MutationObserver(function (mutations) {
            if ($(".et-fb-page-settings-bar .et-fb-page-settings-bar__column.et-fb-page-settings-bar__column--left .et-fb-button-group:first-of-type").length) {
                //$('.et-fb-button.et-fb-button--inverse.et-fb-button--app-modal').css('color', '')
                if (isPhonePreview()) {
                    removePreviewButtons();
                    addPreviewButtons('phone');
                    mObserver.disconnect();
                } else if (isTabletPreview()) {
                    removePreviewButtons();
                    addPreviewButtons('tablet');
                    mObserver.disconnect();
                } else if (isDesktopPreview()) {
                    removePreviewButtons();
                    addPreviewButtons('desktop');
                    mObserver.disconnect();
                } else {
                    removePreviewButtons();
                    mObserver.disconnect();
                }
            }
        });
        mObserver.observe(htmlObj.get(0), {attributes: true, subtree: true, childList: true});
        $(document).on('DOMNodeInserted', 'head', function () {
            mObserver.observe(htmlObj.get(0), {attributes: true, subtree: true, childList: true});
        });
        // Custom  Preset Buttons
        bodyObj.on('click', presetPreviewButton, (e) => {
            customPresetSize = $(e.currentTarget).data('size');
            $(presetPreviewButton).css('color', '');
            $(presetPreviewButton).removeClass('pac_drh_active');
            var currentActiveValue = $(e.currentTarget).text();
            if (currentActiveValue) {
                var width = currentActiveValue;
                customPresetVal = currentActiveValue;
                jQuery(previewSizeInputFiled).val(currentActiveValue);
            }
            var customValue = jQuery(previewSizeInputFiled).val();
            if (customValue) {
                width = customValue;
                customPresetVal = customValue;
            }
            $(e.currentTarget).css(activeColor);
            $(e.currentTarget).addClass('pac_drh_active');
            var containerSelector = '';
            if (isDesktopPreview()) {
                containerSelector = '.et_fb_preview_active--responsive_preview--desktop_preview .et_fb_preview_container';
            }
            if (isTabletPreview()) {
                containerSelector = '.et_fb_preview_active--responsive_preview--tablet_preview .et_fb_preview_container';
            }
            if (isPhonePreview()) {
                containerSelector = '.et_fb_preview_active--responsive_preview--phone_preview .et_fb_preview_container';
            }
            $(previewSizeInputFiled).on('keyup change click', function (e) {
                width = jQuery(previewSizeInputFiled).val();
                $(containerSelector).width(width);
                if (isBackendBuilder()) {
                    $('#et-bfb-app-frame').width(width);
                } else {
                    $('#et-fb-app-frame').width(width);
                }
                var pacCurrentActiveTab = jQuery('button.pac_preset_preview_button');
                pacCurrentActiveTab.each(function () {
                    var pac_drh_button_size = jQuery(this).text();
                    var pac_current_input = jQuery(previewSizeInputFiled).val();
                    if (pac_drh_button_size === pac_current_input) {
                        jQuery(this).css(activeColor);
                    } else {
                        jQuery(this).css('color', '');
                    }
                });
            });
            $(previewSizeInputFiled).mouseleave(function () {
                setTimeout(function () {
                    var newPreviewSWize = jQuery(previewSizeInputFiled).val();
                    if ((newPreviewSWize > 0) && (newPreviewSWize < 768)) {
                        if (isTabletPreview() || isDesktopPreview()) {
                            jQuery('.et-fb-icon--phone').click();
                            setTimeout(function () {
                                jQuery(previewSizeInputFiled).val(newPreviewSWize).click();
                            }, 1200);
                        }
                    }
                    if ((newPreviewSWize > 767) && (newPreviewSWize < 982)) {
                        if (isPhonePreview() || isDesktopPreview()) {
                            jQuery('.et-fb-icon--tablet').click();
                            setTimeout(function () {
                                jQuery(previewSizeInputFiled).val(newPreviewSWize).click();
                            }, 1200);
                        }
                    }
                    if (newPreviewSWize > 980) {
                        if (isPhonePreview() || isTabletPreview()) {
                            jQuery('.et-fb-icon--desktop').click();
                            setTimeout(function () {
                                jQuery(previewSizeInputFiled).val(newPreviewSWize).click();
                            }, 1200);
                        }
                    }
                    jQuery(previewSizeInputFiled).blur();
                }, 1000);
            });
            $(containerSelector).width(width);
            var bodyWidth = $("body").width();
            var etAppFrame = '#et-fb-app-frame';
            var etFBModal = '.et-fb-modal';
            var etModalWidth = $(etFBModal).width();
            var isFrontend = true;
            if ($('#et-bfb-app-frame').length > 0) {
                etAppFrame = '#et-bfb-app-frame'
                isFrontend = false;
            }
            var etModalLeft = $(etFBModal).hasClass("et-fb-modal--snapped-left");
            var etModalRight = $(etFBModal).hasClass("et-fb-modal--snapped-right");
            if (isFrontend) {
                if (etModalLeft || etModalRight) {
                    var translate = (bodyWidth - etModalWidth - width) / 2;
                    var operator = etModalLeft ? "-" : "";
                    if (width !== '1200') {
                        $(etAppFrame).css({'width': width, 'transform': 'translate(' + operator + translate + 'px)'});
                    } else {
                        $(etAppFrame).css({'width': bodyWidth - etModalWidth, 'transform': 'scale(1) translate(0px)'});
                    }
                } else {
                    $(etAppFrame).width(width);
                }
            } else {
                $(etAppFrame).width(width);
            }
        });
        // Reset Preset
        bodyObj.on('click', '.et-fb-button.et-fb-button--inverse:not(.pac_preset)', (e) => {
            customPresetSize = '';
            customPresetVal = '';
        });
    });
})(jQuery);