<?php
/**
 * Filter Fields
 *
 * @param $fields_unprocessed
 *
 * @return array
 */
if (!function_exists('pac_drh_filter_tabs_fields')) {
    function pac_drh_filter_tabs_fields($fields_unprocessed)
    {
        global $shortname;
        $custom_fields = [];
        $custom_fields['pac_drh_tabs_layout_tablet'] = [
            'label' => __('Layout On Tablet', $shortname),
            'type' => 'select',
            'options' => [
                'off' => __('Default', $shortname),
                'pac_drh_tabs_vertical_tab' => __('Vertical', $shortname),
            ],
            'default' => 'off',
            'description' => __('Choose a tab layout to use on Tablet.', $shortname),
            'tab_slug' => 'advanced',
        ];
        $custom_fields['pac_drh_tabs_layout_phone'] = [
            'label' => __('Layout On Phone', $shortname),
            'type' => 'select',
            'options' => [
                'off' => __('Default', $shortname),
                'pac_drh_tabs_horizontal_phone' => __('Horizontal', $shortname),
            ],
            'default' => 'off',
            'description' => __('Choose a tab layout to use on Phone.', $shortname),
            'tab_slug' => 'advanced',
        ];

        return wp_parse_args($custom_fields, $fields_unprocessed);
    }

    add_filter('et_pb_all_fields_unprocessed_et_pb_tabs', 'pac_drh_filter_tabs_fields');
}
/**
 * Filter Output
 *
 * @param $output
 * @param $render_slug
 * @param $module
 *
 * @return array|mixed|string|string[]|null
 */
if (!function_exists('pac_drh_filter_tab_output')) {
    function pac_drh_filter_tab_output($output, $render_slug, $module)
    {
        if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
            return $output;
        }
        if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
            return $output;
        }
        if (is_admin() || wp_doing_ajax() || is_array($output)) {
            return $output;
        }
        if ('et_pb_tabs' !== $render_slug) {
            return $output;
        }
        $tabs_layout_tablet = isset($module->props['pac_drh_tabs_layout_tablet']) ? $module->props['pac_drh_tabs_layout_tablet'] : 'off';
        if ('off' !== $tabs_layout_tablet) {
            $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module '.$tabs_layout_tablet, $output);
        }
        $tabs_layout_phone = isset($module->props['pac_drh_tabs_layout_phone']) ? $module->props['pac_drh_tabs_layout_phone'] : 'off';
        if ('off' !== $tabs_layout_phone) {
            $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module '.$tabs_layout_phone, $output);
        }

        return $output;
    }

    add_filter('et_module_shortcode_output', 'pac_drh_filter_tab_output', 10, 3);
}
/**
 * Add Inline Css
 */
if (!function_exists('pac_drh_tabs_css')) {
    function pac_drh_tabs_css()
    {
        echo PHP_EOL;
        echo "<style id='pac-drh-tabs-inline-css'>";
        /* Tablet */
        echo "@media (min-width:768px) and (max-width:980px){.pac_drh_tabs_vertical_tab .et_pb_tabs_controls li{float:none;border-right:none;border-bottom:1px solid #d9d9d9;display:block}}";
        /* Phone */
        echo "@media (min-width:300px) and (max-width:767px){.pac_drh_tabs_horizontal_phone ul.et_pb_tabs_controls{display:flex;flex-wrap:wrap}.pac_drh_tabs_horizontal_phone .et_pb_tabs_controls li{flex-grow:1}.pac_drh_tabs_horizontal_phone .et_pb_tabs_controls li a{display:block}}";
        echo "</style>";
        echo PHP_EOL;
    }

    add_action('admin_print_styles', 'pac_drh_tabs_css');
    add_action('wp_print_styles', 'pac_drh_tabs_css');
}
