<?php
/**
 * Filter Output
 *
 * @param $output
 * @param $render_slug
 * @param $module
 *
 * @return array|mixed|string|string[]|null
 */
if (!function_exists('pac_drh_add_class_to_row')) {
    function pac_drh_add_class_to_row($output, $render_slug, $module)
    {
        if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
            return $output;
        }
        if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
            return $output;
        }
        if (is_admin() || wp_doing_ajax() || is_array($output)) {
            return $output;
        }
        if ('et_pb_row' !== $render_slug && 'et_pb_row_inner' !== $render_slug) {
            return $output;
        }
        $enable_stacking = isset($module->props['pac_drh_enable_stacking']) ? $module->props['pac_drh_enable_stacking'] : 'off';
        if ('off' !== $enable_stacking) {
            $output = preg_replace("/\b$render_slug\b/", "$render_slug {$module->props['pac_drh_enable_stacking']}", $output);
        }
        $div_columns = explode(",", $module->props['column_structure']);
        $column_structure = preg_replace("/\d_/", "", end($div_columns));
        $tablet_columns = [
            'pac_drh_tab_col_one' => 1,
            'pac_drh_tab_col_two' => 2,
            'pac_drh_tab_col_three' => 3,
            'pac_drh_tab_col_four' => 4,
            'pac_drh_tab_col_five' => 5,
            'pac_drh_tab_col_six' => 6,
        ];
        $phone_columns = [
            'pac_drh_phone_col_one' => 1,
            'pac_drh_phone_col_two' => 2,
            'pac_drh_phone_col_three' => 3,
            'pac_drh_phone_col_four' => 4,
            'pac_drh_phone_col_five' => 5,
            'pac_drh_phone_col_six' => 6,
        ];
        // Tablet
        $column_numbers_tablet = isset($module->props['pac_drh_column_numbers_tablet']) ? $module->props['pac_drh_column_numbers_tablet'] : 'off';
        if ('off' !== $column_numbers_tablet) {
            $col_on_tab = $tablet_columns[$column_numbers_tablet];
            if ('pac_drh_tab_col_two' === $column_numbers_tablet && ($column_structure % $col_on_tab) === 1) {
                $output = preg_replace("/\b$render_slug\b/", "$render_slug pac_drh_tab_fix_2_last_1_col $column_numbers_tablet", $output);
            } elseif ('pac_drh_tab_col_three' === $column_numbers_tablet && ($column_structure % $col_on_tab) === 1) {
                $output = preg_replace("/\b$render_slug\b/", "$render_slug pac_drh_tab_fix_3_last_1_col $column_numbers_tablet", $output);
            } elseif ('pac_drh_tab_col_three' === $column_numbers_tablet && ($column_structure % $col_on_tab) === 2) {
                $output = preg_replace("/\b$render_slug\b/", "$render_slug pac_drh_tab_fix_3_last_2_col $column_numbers_tablet", $output);
            } elseif ('pac_drh_tab_col_four' === $column_numbers_tablet && ($column_structure % $col_on_tab) === 1) {
                $output = preg_replace("/\b$render_slug\b/", "$render_slug pac_drh_tab_fix_4_last_1_col $column_numbers_tablet", $output);
            } elseif ('pac_drh_tab_col_four' === $column_numbers_tablet && ($column_structure % $col_on_tab) === 2) {
                $output = preg_replace("/\b$render_slug\b/", "$render_slug pac_drh_tab_fix_4_last_2_col $column_numbers_tablet", $output);
            } elseif ('pac_drh_tab_col_five' === $column_numbers_tablet && ($column_structure % $col_on_tab) === 1) {
                $output = preg_replace("/\b$render_slug\b/", "$render_slug pac_drh_tab_fix_5_last_1_col $column_numbers_tablet", $output);
            } else {
                $output = preg_replace("/\b$render_slug\b/", "$render_slug $column_numbers_tablet", $output);
            }
        }
        // Phone
        $column_numbers_phone = isset($module->props['pac_drh_column_numbers_phone']) ? $module->props['pac_drh_column_numbers_phone'] : 'off';
        if ('off' !== $column_numbers_phone) {
            $col_on_phone = $phone_columns[$column_numbers_phone];
            if ('pac_drh_phone_col_two' === $column_numbers_phone && ($column_structure % $col_on_phone) === 1) {
                $output = preg_replace("/\b$render_slug\b/", "$render_slug pac_drh_phone_fix_2_last_1_col $column_numbers_phone", $output);
            } elseif ('pac_drh_phone_col_three' === $column_numbers_phone && ($column_structure % $col_on_phone) === 1) {
                $output = preg_replace("/\b$render_slug\b/", "$render_slug pac_drh_phone_fix_3_last_1_col $column_numbers_phone", $output);
            } elseif ('pac_drh_phone_col_three' === $column_numbers_phone && ($column_structure % $col_on_phone) === 2) {
                $output = preg_replace("/\b$render_slug\b/", "$render_slug pac_drh_phone_fix_3_last_2_col $column_numbers_phone", $output);
            } elseif ('pac_drh_phone_col_four' === $column_numbers_phone && ($column_structure % $col_on_phone) === 1) {
                $output = preg_replace("/\b$render_slug\b/", "$render_slug pac_drh_phone_fix_4_last_1_col $column_numbers_phone", $output);
            } elseif ('pac_drh_phone_col_four' === $column_numbers_phone && ($column_structure % $col_on_phone) === 2) {
                $output = preg_replace("/\b$render_slug\b/", "$render_slug pac_drh_phone_fix_4_last_2_col $column_numbers_phone", $output);
            } elseif ('pac_drh_phone_col_five' === $column_numbers_phone && ($column_structure % $col_on_phone) === 1) {
                $output = preg_replace("/\b$render_slug\b/", "$render_slug pac_drh_phone_fix_5_last_1_col $column_numbers_phone", $output);
            } else {
                $output = preg_replace("/\b$render_slug\b/", "$render_slug $column_numbers_phone", $output);
            }
        }

        return $output;
    }

    add_filter('et_module_shortcode_output', 'pac_drh_add_class_to_row', 10, 3);
}
