<?php
/**
 * Filter Fields
 *
 * @param $fields_unprocessed
 *
 * @return array
 */
if (!function_exists('pac_drh_filter_related_products_fields')) {
    function pac_drh_filter_related_products_fields($fields_unprocessed)
    {
        $custom_fields = [];
        $fields_unprocessed['columns_number']['mobile_options'] = true;

        return wp_parse_args($custom_fields, $fields_unprocessed);
    }

    add_filter('et_pb_all_fields_unprocessed_et_pb_wc_related_products', 'pac_drh_filter_related_products_fields');
}
/**
 * Filter Output
 *
 * @param $output
 * @param $render_slug
 * @param $module
 *
 * @return array|mixed|string|string[]|null
 */
if (!function_exists('pac_drh_filter_related_products_output')) {
    function pac_drh_filter_related_products_output($output, $render_slug, $module)
    {
        if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
            return $output;
        }
        if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
            return $output;
        }
        if (is_admin() || wp_doing_ajax() || is_array($output)) {
            return $output;
        }
        if ('et_pb_wc_related_products' !== $render_slug) {
            return $output;
        }
        $margin_between = "4%";
        $columns_number = isset($module->props['columns_number']) ? $module->props['columns_number'] : 0;
        $columns_number_class = "products columns-$columns_number";
        $is_columns_number_responsive = et_pb_responsive_options()->is_responsive_enabled($module->props, 'columns_number');
        $columns_number_tablet = isset($module->props['columns_number_tablet']) ? $module->props['columns_number_tablet'] : '';
        $columns_number_phone = isset($module->props['columns_number_phone']) ? $module->props['columns_number_phone'] : '';
        // Global CSS
        if ($is_columns_number_responsive && (!empty($columns_number_tablet || !empty($columns_number_phone)))) {
            ET_Builder_Element::set_style($render_slug, [
                'selector' => "%%order_class%% ul.products",
                'declaration' => "display: flex; flex-wrap: wrap;",
                'media_query' => ET_Builder_Element::get_media_query('pac_drh_max_980'),
            ]);
        }
        // Tablet CSS
        if ($is_columns_number_responsive && !empty($columns_number_tablet)) {
            $tablet_columns_class = "tablet-columns-$columns_number_tablet";
            $output = preg_replace("/\b$columns_number_class\b/", "$columns_number_class $tablet_columns_class", $output);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => "%%order_class%% ul.products.$tablet_columns_class li.product",
                'declaration' => "width: calc((100% / $columns_number_tablet) - $margin_between + ($margin_between / $columns_number_tablet)) !important; margin-right: $margin_between !important;",
                'media_query' => ET_Builder_Element::get_media_query('pac_drh_min_768_max_980'),
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => "%%order_class%% ul.products.$tablet_columns_class li.product:nth-child({$columns_number_tablet}n)",
                'declaration' => "margin-right: 0 !important;",
                'media_query' => ET_Builder_Element::get_media_query('pac_drh_min_768_max_980'),
            ]);
        }
        // Phone CSS
        if ($is_columns_number_responsive && !empty($columns_number_phone)) {
            $phone_columns_class = "phone-columns-$columns_number_phone";
            $output = preg_replace("/\b$columns_number_class\b/", "$columns_number_class $phone_columns_class", $output);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => "%%order_class%% ul.products.$phone_columns_class li.product",
                'declaration' => "width: calc((100% / $columns_number_phone) - $margin_between + ($margin_between / $columns_number_phone)) !important; margin-right: $margin_between !important;",
                'media_query' => ET_Builder_Element::get_media_query('pac_drh_max_767'),
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => "%%order_class%% ul.products.$phone_columns_class li.product:nth-child({$columns_number_phone}n)",
                'declaration' => "margin-right: 0 !important;",
                'media_query' => ET_Builder_Element::get_media_query('pac_drh_max_767'),
            ]);
        }

        return $output;
    }

    add_filter('et_module_shortcode_output', 'pac_drh_filter_related_products_output', 10, 3);
}

