<?php
/**
 * Filter Fields
 *
 * @param $fields_unprocessed
 *
 * @return array
 */
if (!function_exists('pac_drh_filter_portfolio_fields')) {
    function pac_drh_filter_portfolio_fields($fields_unprocessed)
    {
        global $shortname;
        $custom_fields = [];
        // Number Of Posts
        if (pac_drh_enable_responsive_portfolio_count()) {
            $fields_unprocessed['posts_number']['mobile_options'] = true;
        }
        // Column Numbering
        if (pac_drh_enable_portfolio_number_of_columns()) {
            $custom_fields['pac_drh_column_numbers_desktop'] = [
                'label' => __('Number of Portfolio Columns on Desktop', $shortname),
                'type' => 'select',
                'options' => [
                    'off' => __('Default', $shortname),
                    'pac_drh_desktop_col_one' => __('One', $shortname),
                    'pac_drh_desktop_col_two' => __('Two', $shortname),
                    'pac_drh_desktop_col_three' => __('Three', $shortname),
                    'pac_drh_desktop_col_four' => __('Four', $shortname),
                ],
                'default' => 'off',
                'description' => __('Select the number of Portfolio columns to show on Desktop.', $shortname),
                'tab_slug' => 'advanced',
                'toggle_slug' => 'layout',
                'show_if' => [
                    'fullwidth' => 'off',
                ],
            ];
            $custom_fields['pac_drh_column_numbers_tablet'] = [
                'label' => __('Number of Portfolio Columns on Tablet', $shortname),
                'type' => 'select',
                'options' => [
                    'off' => __('Default', $shortname),
                    'pac_drh_tab_col_one' => __('One', $shortname),
                    'pac_drh_tab_col_two' => __('Two', $shortname),
                    'pac_drh_tab_col_three' => __('Three', $shortname),
                    'pac_drh_tab_col_four' => __('Four', $shortname),
                ],
                'default' => 'off',
                'description' => __('Select the number of Portfolio columns to show on Tablet.', $shortname),
                'tab_slug' => 'advanced',
                'toggle_slug' => 'layout',
                'show_if' => [
                    'fullwidth' => 'off',
                ],
            ];
            $custom_fields['pac_drh_column_numbers_phone'] = [
                'label' => __('Number of Portfolio Columns on Phone', $shortname),
                'type' => 'select',
                'options' => [
                    'off' => __('Default', $shortname),
                    'pac_drh_ph_col_one' => __('One', $shortname),
                    'pac_drh_ph_col_two' => __('Two', $shortname),
                    'pac_drh_ph_col_three' => __('Three', $shortname),
                    'pac_drh_ph_col_four' => __('Four', $shortname),
                ],
                'default' => 'off',
                'description' => __('Select the number of Portfolio columns to show on Phone.', $shortname),
                'tab_slug' => 'advanced',
                'toggle_slug' => 'layout',
                'show_if' => [
                    'fullwidth' => 'off',
                ],
            ];
        }

        return wp_parse_args($custom_fields, $fields_unprocessed);
    }

    add_filter('et_pb_all_fields_unprocessed_et_pb_portfolio', 'pac_drh_filter_portfolio_fields');
    add_filter('et_pb_all_fields_unprocessed_et_pb_filterable_portfolio', 'pac_drh_filter_portfolio_fields');
}
/**
 * Filter Props
 *
 * @param $props
 * @param $attrs
 * @param $render_slug
 * @param $_address
 * @param $content
 *
 * @return mixed
 */
if (!function_exists('pac_drh_filter_portfolio_props')) {

    function pac_drh_filter_portfolio_props($props, $attrs, $render_slug, $_address, $content)
    {
        if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
            return $props;
        }
        if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
            return $props;
        }
        if (is_admin() || wp_doing_ajax()) {
            return $props;
        }
        if ('et_pb_portfolio' !== $render_slug && 'et_pb_fullwidth_portfolio' !== $render_slug && 'et_pb_filterable_portfolio' !== $render_slug) {
            return $props;
        }
        $posts_number = isset($props['posts_number']) ? esc_html($props['posts_number']) : 10;
        $posts_number_values = et_pb_responsive_options()->get_property_values($props, 'posts_number');
        $posts_number_tablet = (isset($posts_number_values['tablet']) && !empty($posts_number_values['tablet'])) ? $posts_number_values['tablet'] : $posts_number;
        $posts_number_phone = (isset($posts_number_values['phone']) && !empty($posts_number_values['phone'])) ? $posts_number_values['phone'] : $posts_number_tablet;
        $responsive_status = et_pb_responsive_options()->is_responsive_enabled($props, 'posts_number');
        if ($responsive_status) {
            $detect_mobile = pac_drh_detect_mobile();
            if (!empty($posts_number_tablet) && $detect_mobile->isTablet()) {
                $props['posts_number'] = $posts_number_tablet;
            }
            if (!empty($posts_number_phone) && $detect_mobile->isMobile() && !$detect_mobile->isTablet()) {
                $props['posts_number'] = $posts_number_phone;
            }
        }

        return $props;
    }

    if (pac_drh_enable_responsive_portfolio_count()) {
        add_filter('et_pb_module_shortcode_attributes', 'pac_drh_filter_portfolio_props', 10, 5);
    }
}
/**
 * Filter Output
 *
 * @param $output
 * @param $render_slug
 * @param $module
 *
 * @return array|mixed|string|string[]|null
 */
if (!function_exists('pac_drh_filter_portfolio_output')) {
    function pac_drh_filter_portfolio_output($output, $render_slug, $module)
    {
        if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
            return $output;
        }
        if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
            return $output;
        }
        if (is_admin() || wp_doing_ajax() || is_array($output)) {
            return $output;
        }
        if ('et_pb_portfolio' === $render_slug || 'et_pb_fullwidth_portfolio' === $render_slug || 'et_pb_filterable_portfolio' === $render_slug) {
            $posts_number = $module->props['posts_number'];
            $include_categories = !empty($module->props['include_categories']) ? explode(',', $module->props['include_categories']) : (array)null;
            // Prepare query arguments
            $query_args = [
                'posts_per_page' => (int)$posts_number,
                'post_type' => 'project',
                'post_status' => ['publish'],
                'perm' => 'readable',
            ];
            // phpcs:disable
            if (!empty($include_categories) and in_array("all", $include_categories) == false) {
                $query_args['tax_query'] = [
                    [
                        'taxonomy' => 'project_category',
                        'field' => 'id',
                        'terms' => $include_categories,
                        'operator' => 'IN',
                    ],
                ];
            }
            // phpcs:enable
            $the_query = new WP_Query($query_args);
            $total_post = $the_query->found_posts;
            if ($total_post > $posts_number) {
                $total_post = $posts_number;
            }
            $column_numbers_desktop = isset($module->props['pac_drh_column_numbers_desktop']) ? $module->props['pac_drh_column_numbers_desktop'] : 'off';
            $column_numbers_tablet = isset($module->props['pac_drh_column_numbers_tablet']) ? $module->props['pac_drh_column_numbers_tablet'] : 'off';
            $column_numbers_phone = isset($module->props['pac_drh_column_numbers_phone']) ? $module->props['pac_drh_column_numbers_phone'] : 'off';
            if ('off' !== $column_numbers_desktop) {
                if ($column_numbers_desktop === 'pac_drh_desktop_col_two' && (($total_post % 2) === 1)) {
                    $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module pac_drh_desktop_2_col_last_r_1_element_fix', $output);
                }
                if ($column_numbers_desktop === 'pac_drh_desktop_col_three' && (($total_post % 3) === 1)) {
                    $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module pac_drh_desktop_3_col_last_r_1_element_fix', $output);
                }
                if ($column_numbers_desktop === 'pac_drh_desktop_col_three' && (($total_post % 3) === 2)) {
                    $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module pac_drh_desktop_3_col_last_r_2_element_fix', $output);
                }
                $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module '.$column_numbers_desktop, $output);
            }
            if ('off' !== $column_numbers_tablet) {
                if ($column_numbers_tablet === 'pac_drh_tab_col_two' && (($total_post % 2) === 1)) {
                    $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module pac_drh_tab_2_col_last_r_1_element_fix', $output);
                }
                if ($column_numbers_tablet === 'pac_drh_tab_col_four' && (($total_post % 4) === 1)) {
                    $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module pac_drh_tab_4_col_last_r_1_element_fix', $output);
                }
                if ($column_numbers_tablet === 'pac_drh_tab_col_four' && (($total_post % 4) === 2)) {
                    $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module pac_drh_tab_4_col_last_r_2_element_fix', $output);
                }
                if ($column_numbers_tablet === 'pac_drh_tab_col_four' && (($total_post % 4) === 3)) {
                    $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module pac_drh_tab_4_col_last_r_3_element_fix', $output);
                }
                $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module '.$column_numbers_tablet, $output);
            }
            if ('off' !== $column_numbers_phone) {
                if ($column_numbers_phone === 'pac_drh_ph_col_three' && (($total_post % 3) === 1)) {
                    $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module pac_drh_ph_3_col_last_r_1_element_fix', $output);
                }
                if ($column_numbers_phone === 'pac_drh_ph_col_three' && (($total_post % 3) === 2)) {
                    $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module pac_drh_ph_3_col_last_r_2_element_fix', $output);
                }
                if ($column_numbers_phone === 'pac_drh_ph_col_four' && (($total_post % 4) === 1)) {
                    $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module pac_drh_ph_4_col_last_r_1_element_fix', $output);
                }
                if ($column_numbers_phone === 'pac_drh_ph_col_four' && (($total_post % 4) === 2)) {
                    $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module pac_drh_ph_4_col_last_r_2_element_fix', $output);
                }
                if ($column_numbers_phone === 'pac_drh_ph_col_four' && (($total_post % 4) === 3)) {
                    $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module pac_drh_ph_4_col_last_r_3_element_fix', $output);
                }
                $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module '.$column_numbers_phone, $output);
            }
        }

        return $output;
    }

    if (pac_drh_enable_portfolio_number_of_columns()) {
        add_filter('et_module_shortcode_output', 'pac_drh_filter_portfolio_output', 10, 3);
    }
}
