<?php
/**
 * Add Custom Toggles
 *
 * @param $modules
 * @param $post_type
 *
 * @return mixed
 */
if (!function_exists('pac_drh_filter_menu_toggles')) {
    function pac_drh_filter_menu_toggles($modules, $post_type)
    {
        static $is_applied = false;
        if ($is_applied) {
            return $modules;
        }
        if (empty($modules)) {
            return $modules;
        }
        foreach ($modules as $module_slug => $module) {
            if ('et_pb_menu' === $module_slug) {
                if (!isset($module->settings_modal_toggles) || !isset($module->fields_unprocessed)) {
                    continue;
                }
                $toggles_list = $module->settings_modal_toggles;
                if (isset($toggles_list['general']) && !empty($toggles_list['general']['toggles'])) {
                    $toggles_list['general']['toggles']['divi_responsive_helper'] = [
                        'title' => __('Divi Responsive Helper', 'Divi'),
                        'priority' => 15,
                    ];
                    $module->settings_modal_toggles = $toggles_list;
                }
            }
        }
        $is_applied = true;

        return $modules;
    }

    add_filter('et_builder_get_parent_modules', 'pac_drh_filter_menu_toggles', 10, 2);
}
/**
 * Filter Menu Fields
 *
 * @param $fields_unprocessed
 *
 * @return array
 */
if (!function_exists('pac_drh_filter_menu_fields')) {
    function pac_drh_filter_menu_fields($fields_unprocessed)
    {
        global $shortname;
        $custom_fields = [];
        // Choose Navigation Menu Per Device In Menu Module
        $fields_unprocessed['menu_id']['mobile_options'] = true;
        // Show A Hamburger Menu On Desktop
        $custom_fields['use_hamburger_menu_desktop'] = [
            'label' => __('Show A Hamburger Menu On Desktop', $shortname),
            'type' => 'yes_no_button',
            'description' => __('Choose to replace the open Desktop menu with a hamburger menu instead.', $shortname),
            'options' => [
                'on' => et_builder_i18n('Yes'),
                'off' => et_builder_i18n('No'),
            ],
            'default' => 'off',
            'option_category' => 'basic_option',
            'toggle_slug' => 'divi_responsive_helper',
        ];
        $custom_fields['closed_menu_icon'] = [
            'label' => __('Menu Closed Icon', $shortname),
            'type' => 'select_icon',
            'description' => __('Choose an icon for the menu when it is closed.', $shortname),
            'default' => 'a',
            'option_category' => 'basic_option',
            'toggle_slug' => 'divi_responsive_helper',
        ];
        $custom_fields['opened_menu_icon'] = [
            'label' => __('Menu Opened Icon', $shortname),
            'type' => 'select_icon',
            'description' => __('Choose an icon for the menu when it is opened.', $shortname),
            'default' => 'M',
            'option_category' => 'basic_option',
            'toggle_slug' => 'divi_responsive_helper',
        ];
        // Add Text Beside Hamburger Menu Icon
        $custom_fields['use_hamburger_menu_text'] = [
            'label' => __('Add Text Beside Hamburger Menu Icon', $shortname),
            'type' => 'yes_no_button',
            'description' => __('Add custom text to the left side of the hamburger menu icon.', $shortname),
            'options' => [
                'on' => et_builder_i18n('Yes'),
                'off' => et_builder_i18n('No'),
            ],
            'default' => 'off',
            'option_category' => 'basic_option',
            'toggle_slug' => 'divi_responsive_helper',
        ];
        // Hamburger Menu Text
        $custom_fields['hamburger_menu_text'] = [
            'label' => __('Hamburger Menu Text', $shortname),
            'type' => 'text',
            'description' => __('Enter custom text to show on the left side of the hamburger menu icon.', $shortname),
            'default' => __('Menu', $shortname),
            'show_if' => [
                'use_hamburger_menu_text' => 'on'
            ],
            'option_category' => 'basic_option',
            'toggle_slug' => 'divi_responsive_helper',
        ];
        // Show An Open Menu On Phone
        $custom_fields['use_opened_menu_on_phone'] = [
            'label' => __('Show An Open Menu On Phone', $shortname),
            'type' => 'yes_no_button',
            'description' => __('Choose to remove the hamburger menu icon and open the menu instead on Phone devices.', $shortname),
            'options' => [
                'on' => et_builder_i18n('Yes'),
                'off' => et_builder_i18n('No'),
            ],
            'default' => 'off',
            'option_category' => 'basic_option',
            'toggle_slug' => 'divi_responsive_helper',
        ];
        // Collapse Mobile Menu Submenus
        $custom_fields['use_collapse_mobile_submenus'] = [
            'label' => __('Collapse Mobile Menu Submenus', $shortname),
            'type' => 'yes_no_button',
            'description' => __('Choose to collapse the submenu by default.', $shortname),
            'options' => [
                'on' => et_builder_i18n('Yes'),
                'off' => et_builder_i18n('No'),
            ],
            'default' => 'off',
            'option_category' => 'basic_option',
            'toggle_slug' => 'divi_responsive_helper',
        ];
        $custom_fields['use_collapse_other_submenus'] = [
            'label' => __('Collapse Submenu When Another Is Opened', $shortname),
            'type' => 'yes_no_button',
            'description' => __('Choose to collapse the open submenu when another submenu is opened.', $shortname),
            'options' => [
                'on' => et_builder_i18n('Yes'),
                'off' => et_builder_i18n('No'),
            ],
            'default' => 'off',
            'show_if' => ['use_collapse_mobile_submenus' => 'on'],
            'option_category' => 'basic_option',
            'toggle_slug' => 'divi_responsive_helper',
        ];
        // Open/Close Submenus By Clicking Parent Menu Item
        $custom_fields['use_openclose_submenu_with_parent'] = [
            'label' => __('Open/Close Submenus By Clicking Parent Menu Item', $shortname),
            'type' => 'yes_no_button',
            'description' => __('Choose to open and close the submenu by clicking the parent menu item. This effectively disables the parent menu link.', $shortname),
            'options' => [
                'on' => et_builder_i18n('Yes'),
                'off' => et_builder_i18n('No'),
            ],
            'default' => 'off',
            'show_if' => ['use_collapse_mobile_submenus' => 'on'],
            'option_category' => 'basic_option',
            'toggle_slug' => 'divi_responsive_helper',
        ];
        // Menu Breakpoint
        $custom_fields['use_menu_break_point'] = [
            'label' => __('Menu Breakpoint', $shortname),
            'type' => 'range',
            'range_settings' => [
                'min' => 0,
                'max' => '2000',
                'step' => '1',
            ],
            'default' => '',
            'validate_unit' => true,
            'fixed_unit' => 'px',
            'fixed_range' => true,
            'description' => __('Enter the screen width pixel value for the responsive breakpoint for for when the menu changes between desktop and mobile versions. The default value in Divi is 981px.',
                $shortname),
            'option_category' => 'basic_option',
            'toggle_slug' => 'divi_responsive_helper',
        ];

        return wp_parse_args($custom_fields, $fields_unprocessed);
    }

    add_filter('et_pb_all_fields_unprocessed_et_pb_menu', 'pac_drh_filter_menu_fields');
}
/**
 * Filter Menu Props
 *
 * @param $props
 * @param $attrs
 * @param $render_slug
 * @param $_address
 * @param $content
 *
 * @return mixed
 */
if (!function_exists('pac_drh_filter_menu_props')) {
    function pac_drh_filter_menu_props($props, $attrs, $render_slug, $_address, $content)
    {
        if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
            return $props;
        }
        if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
            return $props;
        }
        if (is_admin() || wp_doing_ajax()) {
            return $props;
        }
        if ('et_pb_menu' !== $render_slug) {
            return $props;
        }
        // Choose Navigation Menu Per Device In Menu Module
        $menu_id = isset($props['menu_id']) ? esc_html($props['menu_id']) : null;
        $menu_id_last_edited = isset($props['menu_id_last_edited']) ? esc_html($props['menu_id_last_edited']) : null;
        $responsive_status = et_pb_get_responsive_status($menu_id_last_edited);
        $menu_id_tablet = isset($props['menu_id_tablet']) ? esc_html($props['menu_id_tablet']) : $menu_id;
        $menu_id_phone = isset($props['menu_id_phone']) ? esc_html($props['menu_id_phone']) : $menu_id_tablet;
        if ($responsive_status) {
            $detect_mobile = pac_drh_detect_mobile();
            if (!empty($menu_id_tablet) && $detect_mobile->isTablet()) {
                $props['menu_id'] = $menu_id_tablet;
            }
            if (!empty($menu_id_phone) && $detect_mobile->isMobile() && !$detect_mobile->isTablet()) {
                $props['menu_id'] = $menu_id_phone;
            }
        }

        return $props;
    }

    add_filter('et_pb_module_shortcode_attributes', 'pac_drh_filter_menu_props', 10, 5);
}
/**
 * Filter Menu Output
 *
 * @param $output
 * @param $render_slug
 * @param $module
 *
 * @return mixed
 */
if (!function_exists('pac_drh_filter_menu_output')) {
    function pac_drh_filter_menu_output($output, $render_slug, $module)
    {
        if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
            return $output;
        }
        if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
            return $output;
        }
        if (is_admin() || wp_doing_ajax() || is_array($output)) {
            return $output;
        }
        if ('et_pb_menu' !== $render_slug) {
            return $output;
        }
        $props = $module->props;
        $module_order = ET_Builder_Element::get_module_order_class($render_slug);
        $order_class = '.'.$module_order;
        //======================================================================
        // Menu Icon
        //======================================================================
        $closed_menu_icon = isset($props['closed_menu_icon']) ? $props['closed_menu_icon'] : '';
        if (!empty($closed_menu_icon)) {
            if ((function_exists('et_pb_get_icon_font_family') && function_exists('et_pb_get_icon_font_weight'))) {
                ET_Builder_Element::set_style($render_slug, [
                    'selector' => '%%order_class%% .et_mobile_nav_menu .mobile_nav.closed .mobile_menu_bar:before',
                    'declaration' => sprintf("font-family:%s !important;font-weight:%s;", et_pb_get_icon_font_family($closed_menu_icon), et_pb_get_icon_font_weight($closed_menu_icon)),
                ]);
            }
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% .et_mobile_nav_menu .mobile_nav.closed .mobile_menu_bar:before',
                'declaration' => sprintf("content:'%s';", html_entity_decode(esc_attr(et_pb_process_font_icon($closed_menu_icon))))
            ]);
        }
        $opened_menu_icon = isset($props['opened_menu_icon']) ? $props['opened_menu_icon'] : '';
        if (!empty($opened_menu_icon)) {
            if ((function_exists('et_pb_get_icon_font_family') && function_exists('et_pb_get_icon_font_weight'))) {
                ET_Builder_Element::set_style($render_slug, [
                    'selector' => '%%order_class%% .et_mobile_nav_menu .mobile_nav.opened .mobile_menu_bar:before',
                    'declaration' => sprintf("font-family:%s !important;font-weight:%s;", et_pb_get_icon_font_family($opened_menu_icon), et_pb_get_icon_font_weight($opened_menu_icon)),
                ]);
            }
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% .et_mobile_nav_menu .mobile_nav.opened .mobile_menu_bar:before',
                'declaration' => sprintf("content:'%s';", html_entity_decode(esc_attr(et_pb_process_font_icon($opened_menu_icon))))
            ]);
        }
        //======================================================================
        // Add Text Beside Hamburger Menu Icon
        //======================================================================
        $use_hamburger_menu_text = isset($props['use_hamburger_menu_text']) && 'on' === $props['use_hamburger_menu_text'];
        if ($use_hamburger_menu_text && (isset($props['hamburger_menu_text']) && !empty($props['hamburger_menu_text']))) {
            $hamburger_menu_text = $props['hamburger_menu_text'];
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% .et_mobile_nav_menu:before',
                'declaration' => sprintf("content:'%s';position:relative;", esc_attr($hamburger_menu_text)),
            ]);
            /*  ET_Builder_Element::set_style($render_slug, [
                  'selector' => '%%order_class%% .et_mobile_nav_menu:before',
                  'declaration' => "top:0;",
                  'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
              ]);*/
        }
        //======================================================================
        // Show A Hamburger Menu On Desktop
        //======================================================================
        $use_hamburger_menu_desktop = isset($props['use_hamburger_menu_desktop']) && 'on' === $props['use_hamburger_menu_desktop'];
        if ($use_hamburger_menu_desktop) {
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%%.et_pb_menu .et_pb_menu__menu, .et_pb_fullwidth_menu .et_pb_menu__menu',
                'declaration' => 'display:none;',
                'media_query' => ET_Builder_Element::get_media_query('min_width_981'),
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%%.et_pb_menu .et_mobile_nav_menu, .et_pb_fullwidth_menu .et_mobile_nav_menu',
                'declaration' => 'display:flex;float:none;margin:0 6px;align-items:center;',
                'media_query' => ET_Builder_Element::get_media_query('min_width_981'),
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%%.et_pb_menu .et_mobile_nav_menu li',
                'declaration' => 'list-style-type:none;',
                'media_query' => ET_Builder_Element::get_media_query('min_width_981'),
            ]);
        }
        //======================================================================
        // Show An Open Menu On Phone
        //======================================================================
        $use_opened_menu_on_phone = isset($props['use_opened_menu_on_phone']) && 'on' === $props['use_opened_menu_on_phone'];
        if ($use_opened_menu_on_phone) {
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% .et_pb_menu__menu',
                'declaration' => 'display:flex!important;',
                'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% .et_mobile_nav_menu',
                'declaration' => 'display:none!important;',
                'media_query' => ET_Builder_Element::get_media_query('max_width_980'),
            ]);
        }
        //======================================================================
        // Collapse Mobile Menu Submenus
        //======================================================================
        $use_collapse_mobile_submenus = isset($props['use_collapse_mobile_submenus']) && 'on' === $props['use_collapse_mobile_submenus'];
        if ($use_collapse_mobile_submenus) {
            $accent_color = pac_drh_get_color_scheme();
            // CSS
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% ul.et_mobile_menu li.menu-item-has-children .mobile-toggle,%%order_class%% ul.et_mobile_menu li.page_item_has_children .mobile-toggle,%%order_class%% .et-db #et-boc .et-l ul.et_mobile_menu li.menu-item-has-children .mobile-toggle,%%order_class%% .et-db #et-boc .et-l ul.et_mobile_menu li.page_item_has_children .mobile-toggle',
                'declaration' => 'width: 44px;height: 100%;padding: 0px !important;max-height: 44px;border: none;position: absolute;right: 0px;top: 0px;z-index: 999;background-color: transparent;',
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% ul.et_mobile_menu > li.menu-item-has-children,%%order_class%% ul.et_mobile_menu > li.page_item_has_children,%%order_class%% ul.et_mobile_menu > li.menu-item-has-children .sub-menu li.menu-item-has-children,%%order_class%% .et-db #et-boc .et-l ul.et_mobile_menu > li.menu-item-has-children,%%order_class%% .et-db #et-boc .et-l ul.et_mobile_menu > li.page_item_has_children,%%order_class%% .et-db #et-boc .et-l ul.et_mobile_menu > li.menu-item-has-children .sub-menu li.menu-item-has-children',
                'declaration' => 'position: relative;',
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% .et_mobile_menu .menu-item-has-children > a,%%order_class%% .et-db #et-boc .et-l .et_mobile_menu .menu-item-has-children > a',
                'declaration' => 'background-color: transparent;',
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% ul.et_mobile_menu .menu-item-has-children .sub-menu,%%order_class%% #main-header ul.et_mobile_menu .menu-item-has-children .sub-menu,%%order_class%% .et-db #et-boc .et-l ul.et_mobile_menu .menu-item-has-children .sub-menu,%%order_class%% .et-db #main-header ul.et_mobile_menu .menu-item-has-children .sub-menu',
                'declaration' => 'display: none !important;visibility: hidden !important;',
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% ul.et_mobile_menu .menu-item-has-children .sub-menu.visible,%%order_class%% #main-header ul.et_mobile_menu .menu-item-has-children .sub-menu.visible,%%order_class%% .et-db #et-boc .et-l ul.et_mobile_menu .menu-item-has-children .sub-menu.visible,%%order_class%% .et-db #main-header ul.et_mobile_menu .menu-item-has-children .sub-menu.visible',
                'declaration' => 'display: block !important;visibility: visible !important;',
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% ul.et_mobile_menu li.menu-item-has-children .mobile-toggle,%%order_class%% .et-db #et-boc .et-l ul.et_mobile_menu li.menu-item-has-children .mobile-toggle',
                'declaration' => 'text-align: center;opacity: 1;',
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% ul.et_mobile_menu li.menu-item-has-children .mobile-toggle::after,%%order_class%% .et-db #et-boc .et-l ul.et_mobile_menu li.menu-item-has-children .mobile-toggle::after',
                'declaration' => 'top: 10px;position: relative;font-family: "ETModules", serif;content: \'\33\';color: '.esc_attr($accent_color).';background: #f0f3f6;border-radius: 50%;padding: 3px;',
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% ul.et_mobile_menu li.menu-item-has-children.dt-open > .mobile-toggle::after,%%order_class%% .et-db #et-boc .et-l ul.et_mobile_menu li.menu-item-has-children.dt-open > .mobile-toggle::after',
                'declaration' => 'content: \'\32\';',
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% .et_pb_menu .et_mobile_menu:after',
                'declaration' => "position: absolute;right: 5%;margin-left: -20px;top: -23px;width: 0;height: 0;content: '';border-left: 20px solid transparent;border-right: 20px solid transparent;border-bottom: 20px solid #ffffff;",
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% .mobile_menu_bar',
                'declaration' => 'position: relative;display: block;line-height: 0;',
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => '%%order_class%% .et_pb_menu .et_mobile_menu,%%order_class%% .et_pb_menu .et_mobile_menu ul',
                'declaration' => 'background-color: #ffffff !important;border-radius: 10px;',
            ]);
            //======================================================================
            // Open/Close Submenus By Clicking Parent Menu Item
            //======================================================================
            $use_openclose_submenu_with_parent = isset($props['use_openclose_submenu_with_parent']) && 'on' === $props['use_openclose_submenu_with_parent'];
            $use_collapse_other_submenus = isset($props['use_collapse_other_submenus']) && 'on' === $props['use_collapse_other_submenus'];
            add_action('wp_footer', function () use ($use_openclose_submenu_with_parent, $use_collapse_other_submenus, $module_order, $order_class) { ?>
                <script type="text/javascript" id="pac-drh-menu-module-collapse-menu-submenus-inline-js">
                    jQuery(function ($) {
                        $(document).ready(function () {
                            let isCollapseMobileSubMenus = '<?php echo esc_js($use_collapse_other_submenus);?>';
                            $("body .et_pb_menu ul.et_mobile_menu li.menu-item-has-children, body .et_pb_menu ul.et_mobile_menu  li.page_item_has_children").append('<a href="javascript:void(0)" class="mobile-toggle"></a>');
                            $('.et_pb_menu ul.et_mobile_menu li.menu-item-has-children .mobile-toggle, .et_pb_menu ul.et_mobile_menu li.page_item_has_children .mobile-toggle').click(function (event) {
                                event.preventDefault();
                                let parentLIObj = jQuery(this).parent('li');
                                if (parentLIObj.hasClass('dt-open')) {
                                    parentLIObj.toggleClass('dt-open');
                                    parentLIObj.find('ul.children').first().toggleClass('visible');
                                    parentLIObj.find('ul.sub-menu').first().toggleClass('visible');
                                } else {
                                    if (!parentLIObj.parent('ul').hasClass('visible') && isCollapseMobileSubMenus) {
                                        jQuery('li.menu-item-has-children').removeClass('dt-open');
                                        jQuery('li.menu-item-has-children .sub-menu').removeClass('visible');
                                    }
                                    parentLIObj.toggleClass('dt-open');
                                    parentLIObj.find('ul.children').first().toggleClass('visible');
                                    parentLIObj.find('ul.sub-menu').first().toggleClass('visible');
                                }
                            });
                            let iconFINAL = 'P';
                            $('body ul.et_mobile_menu li.menu-item-has-children, body ul.et_mobile_menu li.page_item_has_children').attr('data-icon', iconFINAL);
                            $('.mobile-toggle').on('mouseover', function () {
                                $(this).parent().addClass('is-hover');
                            }).on('mouseout', function () {
                                $(this).parent().removeClass('is-hover');
                            })
                        });
                    });
                </script>
                <?php
                if ($use_openclose_submenu_with_parent) {
                    wp_register_script('pac-drh-menu-module-openclose-submenus-'.$module_order, false);
                    wp_enqueue_script('pac-drh-menu-module-openclose-submenus-'.$module_order);
                    wp_add_inline_script('pac-drh-menu-module-openclose-submenus-'.$module_order, "
                    jQuery(function ($) {
                    jQuery(document).ready(function () {
                        jQuery('$order_class .et_mobile_nav_menu .et_mobile_menu .menu-item-has-children a').each(function () {
                            jQuery(this).on
                            ('click', function (event) {
                                let parent = jQuery(this).siblings('ul').children('li').find('ul');
                                parent.removeClass('visible');
                                parent.toggleClass('visible')
                            })
                        });
                         $('body $order_class .et_mobile_nav_menu ul.et_mobile_menu li.menu-item-has-children, body $order_class .et_mobile_nav_menu ul.et_mobile_menu  li.page_item_has_children').each(function () {
                            var outerThis = this;
                            jQuery(outerThis).find('a:first').attr('href', 'javascript:void(0)').off('click');
                            jQuery(outerThis).find('a:first').click(function (e) {
                                jQuery(outerThis).find('ul').toggleClass('visible')
                            });
                        });
                        })
                    });
                    ");
                }
            });
        }
        //======================================================================
        // Menu Breakpoint
        //======================================================================
        if ((isset($props['use_menu_break_point']) && !empty($props['use_menu_break_point'])) && 0 !== intval($props['use_menu_break_point'])) {
            $breakpoint = esc_html($props['use_menu_break_point']);
            add_action('wp_footer', function () use ($breakpoint, $order_class) {
                echo PHP_EOL;
                $breakpoint_css = '';
                $int_breakpoint = intval($breakpoint);
                if ($int_breakpoint > 981) {
                    $breakpoint_css = "@media only screen and (max-width:".esc_attr($breakpoint)."){ ".esc_attr($order_class)." .et_pb_menu__menu{display:none!important} ".esc_attr($order_class)." .et_mobile_nav_menu{display:flex!important} ".esc_attr($order_class)." ul.et_mobile_menu{list-style-type:none!important;padding:0!important}}";
                }
                if ($int_breakpoint < 980) {
                    $breakpoint_css = "@media only screen and (min-width:".esc_attr($breakpoint)."){ ".esc_attr($order_class)." .et_mobile_nav_menu{display:none!important} ".esc_attr($order_class)." .et_pb_menu__menu{display:flex!important} ".esc_attr($order_class)." ul.et_mobile_menu{list-style-type:none!important;padding:0!important}}";
                }
                echo sprintf('<style id="pac-drh-mmb-%1$s-inline-css">%2$s</style>', esc_html($int_breakpoint), esc_html($breakpoint_css));
                echo "</style>";
                echo PHP_EOL;
            });
        }

        return $output;
    }

    add_filter('et_module_shortcode_output', 'pac_drh_filter_menu_output', 10, 3);
}
