<?php
/**
 * Filter Fields
 *
 * @param $fields_unprocessed
 *
 * @return array|object
 */
if (!function_exists('pac_drh_filter_gallery_fields')) {
    function pac_drh_filter_gallery_fields($fields_unprocessed)
    {
        global $shortname;
        $custom_fields = [];
        // Number Of Posts
        if (pac_drh_enable_responsive_gallery_count()) {
            $fields_unprocessed['posts_number']['mobile_options'] = true;
        }
        // Column Numbering
        if (pac_drh_enable_gallery_number_of_columns()) {
            $custom_fields['pac_drh_column_numbers_desktop'] = [
                'label' => __('Number of Image Columns on Desktop', $shortname),
                'type' => 'select',
                'options' => [
                    'off' => __('Default', $shortname),
                    'pac_drh_desktop_col_one' => __('One', $shortname),
                    'pac_drh_desktop_col_two' => __('Two', $shortname),
                    'pac_drh_desktop_col_three' => __('Three', $shortname),
                    'pac_drh_desktop_col_four' => __('Four', $shortname),
                    'pac_drh_desktop_col_five' => __('Five', $shortname),
                    'pac_drh_desktop_col_six' => __('Six', $shortname),
                ],
                'default' => 'off',
                'description' => __('Select the number of image columns to show on Desktop.', $shortname),
                'tab_slug' => 'advanced',
                'toggle_slug' => 'layout',
                'show_if' => [
                    'fullwidth' => 'off',
                ],
            ];
            $custom_fields['pac_drh_column_numbers_tablet'] = [
                'label' => __('Number of Image Columns on Tablet', $shortname),
                'type' => 'select',
                'options' => [
                    'off' => __('Default', $shortname),
                    'pac_drh_tab_col_one' => __('One', $shortname),
                    'pac_drh_tab_col_two' => __('Two', $shortname),
                    'pac_drh_tab_col_three' => __('Three', $shortname),
                    'pac_drh_tab_col_four' => __('Four', $shortname),
                    'pac_drh_tab_col_five' => __('Five', $shortname),
                    'pac_drh_tab_col_six' => __('Six', $shortname),
                ],
                'default' => 'off',
                'description' => __('Select the number of image columns to show on Tablet.', $shortname),
                'tab_slug' => 'advanced',
                'toggle_slug' => 'layout',
                'show_if' => [
                    'fullwidth' => 'off',
                ],
            ];
            $custom_fields['pac_drh_column_numbers_phone'] = [
                'label' => __('Number of Image Columns on Phone', $shortname),
                'type' => 'select',
                'options' => [
                    'off' => __('Default', $shortname),
                    'pac_drh_ph_col_one' => __('One', $shortname),
                    'pac_drh_ph_col_two' => __('Two', $shortname),
                    'pac_drh_ph_col_three' => __('Three', $shortname),
                    'pac_drh_ph_col_four' => __('Four', $shortname),
                    'pac_drh_ph_col_five' => __('Five', $shortname),
                    'pac_drh_ph_col_six' => __('Six', $shortname),
                ],
                'default' => 'off',
                'description' => __('Select the number of image columns to show on Phone.', $shortname),
                'tab_slug' => 'advanced',
                'toggle_slug' => 'layout',
                'show_if' => [
                    'fullwidth' => 'off',
                ],
            ];
        }

        return wp_parse_args($custom_fields, $fields_unprocessed);
    }

    add_filter('et_pb_all_fields_unprocessed_et_pb_gallery', 'pac_drh_filter_gallery_fields');
}
/**
 * Filter Props
 *
 * @param $props
 * @param $attrs
 * @param $render_slug
 * @param $_address
 * @param $content
 *
 * @return mixed
 */
if (!function_exists('pac_drh_filter_gallery_props')) {

    function pac_drh_filter_gallery_props($props, $attrs, $render_slug, $_address, $content)
    {
        if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
            return $props;
        }
        if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
            return $props;
        }
        if (is_admin() || wp_doing_ajax()) {
            return $props;
        }
        if ('et_pb_gallery' !== $render_slug) {
            return $props;
        }
        $posts_number = isset($props['posts_number']) ? esc_html($props['posts_number']) : 4;
        $posts_number_values = et_pb_responsive_options()->get_property_values($props, 'posts_number');
        $posts_number_tablet = (isset($posts_number_values['tablet']) && !empty($posts_number_values['tablet'])) ? $posts_number_values['tablet'] : $posts_number;
        $posts_number_phone = (isset($posts_number_values['phone']) && !empty($posts_number_values['phone'])) ? $posts_number_values['phone'] : $posts_number_tablet;
        $responsive_status = et_pb_responsive_options()->is_responsive_enabled($props, 'posts_number');
        if ($responsive_status) {
            $detect_mobile = pac_drh_detect_mobile();
            if (!empty($posts_number_tablet) && $detect_mobile->isTablet()) {
                $props['posts_number'] = $posts_number_tablet;
            }
            if (!empty($posts_number_phone) && $detect_mobile->isMobile() && !$detect_mobile->isTablet()) {
                $props['posts_number'] = $posts_number_phone;
            }
        }

        return $props;
    }

    if (pac_drh_enable_responsive_gallery_count()) {
        add_filter('et_pb_module_shortcode_attributes', 'pac_drh_filter_gallery_props', 10, 5);
    }
}
/**
 * Filter Output
 *
 * @param $output
 * @param $render_slug
 * @param $module
 *
 * @return array|mixed|string|string[]|null
 */
if (!function_exists('pac_drh_filter_gallery_output')) {
    function pac_drh_filter_gallery_output($output, $render_slug, $module)
    {
        if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
            return $output;
        }
        if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
            return $output;
        }
        if (is_admin() || wp_doing_ajax() || is_array($output)) {
            return $output;
        }
        if ('et_pb_gallery' !== $render_slug) {
            return $output;
        }
        if (strpos($output, 'et_pb_gallery_grid') === false) {
            return $output;
        }
        $gallery_ids = $module->props['gallery_ids'];
        $gallery_ids = count(explode(',', $gallery_ids));
        $column_numbers_desktop = isset($module->props['pac_drh_column_numbers_desktop']) ? $module->props['pac_drh_column_numbers_desktop'] : 'off';
        $column_numbers_tablet = isset($module->props['pac_drh_column_numbers_tablet']) ? $module->props['pac_drh_column_numbers_tablet'] : 'off';
        $column_numbers_phone = isset($module->props['pac_drh_column_numbers_phone']) ? $module->props['pac_drh_column_numbers_phone'] : 'off';
        if ('off' !== $column_numbers_desktop) {
            if ($column_numbers_desktop === 'pac_drh_desktop_col_three' & (($gallery_ids % 3) === 1)) {
                $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery pac_drh_desktop_3_col_last_r_1_element_fix', $output);
            }
            $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery '.$column_numbers_desktop, $output);
        }
        if ('off' !== $column_numbers_tablet) {
            if ($column_numbers_tablet === 'pac_drh_tab_col_four' & (($gallery_ids % 4) === 1)) {
                $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery pac_drh_tab_4_col_last_r_1_element_fix', $output);
            }
            if ($column_numbers_tablet === 'pac_drh_tab_col_four' & (($gallery_ids % 4) === 2)) {
                $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery pac_drh_tab_4_col_last_r_2_element_fix', $output);
            }
            if ($column_numbers_tablet === 'pac_drh_tab_col_five' & (($gallery_ids % 4) === 2)) {
                $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery pac_drh_tab_5_col_last_r_2_element_fix', $output);
            }
            if ($column_numbers_tablet === 'pac_drh_tab_col_five' & (($gallery_ids % 4) === 1)) {
                $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery pac_drh_tab_5_col_last_r_1_element_fix', $output);
            }
            if ($column_numbers_tablet === 'pac_drh_tab_col_six' & (($gallery_ids % 5) === 2)) {
                $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery pac_drh_tab_6_col_last_r_2_element_fix', $output);
            }
            if ($column_numbers_tablet === 'pac_drh_tab_col_six' & (($gallery_ids % 5) === 1)) {
                $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery pac_drh_tab_6_col_last_r_1_element_fix', $output);
            }
            $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery '.$column_numbers_tablet, $output);
        }
        if ('off' !== $column_numbers_phone) {
            if ($column_numbers_phone === 'pac_drh_ph_col_three' & (($gallery_ids % 3) === 1)) {
                $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery pac_drh_ph_3_col_last_r_1_element_fix', $output);
            }
            if ($column_numbers_phone === 'pac_drh_ph_col_four' & (($gallery_ids % 4) === 2)) {
                $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery pac_drh_ph_4_col_last_r_2_element_fix', $output);
            }
            if ($column_numbers_phone === 'pac_drh_ph_col_four' & (($gallery_ids % 4) === 1)) {
                $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery pac_drh_ph_4_col_last_r_1_element_fix', $output);
            }
            if ($column_numbers_phone === 'pac_drh_ph_col_five' & (($gallery_ids % 5) === 2)) {
                $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery pac_drh_ph_5_col_last_r_2_element_fix', $output);
            }
            if ($column_numbers_phone === 'pac_drh_ph_col_five' & (($gallery_ids % 5) === 1)) {
                $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery pac_drh_ph_5_col_last_r_1_element_fix', $output);
            }
            if ($column_numbers_phone === 'pac_drh_ph_col_six' & (($gallery_ids % 6) === 2)) {
                $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery pac_drh_ph_6_col_last_r_2_element_fix', $output);
            }
            if ($column_numbers_phone === 'pac_drh_ph_col_six' & (($gallery_ids % 6) === 1)) {
                $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery pac_drh_ph_6_col_last_r_1_element_fix', $output);
            }
            $output = preg_replace('/\bet_pb_module et_pb_gallery\b/', 'et_pb_module et_pb_gallery '.$column_numbers_phone, $output);
        }

        return $output;
    }

    if (pac_drh_enable_gallery_number_of_columns()) {
        add_filter('et_module_shortcode_output', 'pac_drh_filter_gallery_output', 10, 3);
    }
}