<?php
/**
 * Filter Fields
 *
 * @param $fields_unprocessed
 *
 * @return array
 */
if (!function_exists('pac_drh_filter_row_fields')) {
    function pac_drh_filter_row_fields($fields_unprocessed)
    {
        global $shortname;
        $custom_fields = [];
        $custom_fields['pac_drh_custom_gutter_value'] = [
            'label' => __('Custom Gutter Value', $shortname),
            'type' => 'text',
            'default' => '',
            'description' => __('Enter an optional custom gutter value and unit to override the default gutter value.', $shortname),
            'mobile_options' => true,
            'validate_unit' => true,
            'allowed_units' => ['%', 'em', 'rem', 'px', 'cm', 'mm', 'in', 'pt', 'pc', 'ex', 'vh', 'vw'],
            'tab_slug' => 'advanced',
            'toggle_slug' => 'width',
            'show_if' => [
                'use_custom_gutter' => 'on'
            ]
        ];

        return wp_parse_args($custom_fields, $fields_unprocessed);
    }

    add_filter('et_pb_all_fields_unprocessed_et_pb_row', 'pac_drh_filter_row_fields');
}
/**
 * Filter Output
 *
 * @param $output
 * @param $render_slug
 * @param $module
 *
 * @return array|mixed|string|string[]|null
 */
if (!function_exists('pac_drh_filter_row_output')) {
    function pac_drh_filter_row_output($output, $render_slug, $module)
    {
        if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
            return $output;
        }
        if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
            return $output;
        }
        if (is_admin() || wp_doing_ajax() || is_array($output)) {
            return $output;
        }
        if ('et_pb_row' !== $render_slug) {
            return $output;
        }
        $props = $module->props;
        $use_custom_gutter = isset($props['use_custom_gutter']) ? $props['use_custom_gutter'] : 'off';
        if ('on' === $use_custom_gutter) {
            $custom_gutter_value = isset($props['pac_drh_custom_gutter_value']) ? $props['pac_drh_custom_gutter_value'] : '';
            //$custom_gutter_value = '0.875rem';
            $divi_desktop_columns = [
                'simple' => [
                    '1_2,1_2' => 2,
                    '1_3,1_3,1_3' => 3,
                    '1_4,1_4,1_4,1_4' => 4,
                    '1_5,1_5,1_5,1_5,1_5' => 5,
                    '1_6,1_6,1_6,1_6,1_6,1_6' => 6
                ],
                'complex' => [
                    '2_5,3_5' => '2',
                    '3_5,2_5' => '2',
                    '1_3,2_3' => '2',
                    '2_3,1_3' => '2',
                    '1_4,3_4' => '2',
                    '3_4,1_4' => '2',
                    '1_4,1_2,1_4' => '3',
                    '1_5,3_5,1_5' => '3',
                    '1_4,1_4,1_2' => '3',
                    '1_2,1_4,1_4' => '3',
                    '1_5,1_5,3_5' => '3',
                    '3_5,1_5,1_5' => '3',
                    '1_6,1_6,1_6,1_2' => '4',
                    '1_2,1_6,1_6,1_6' => '4'
                ],
            ];
            $divi_tablet_columns = [
                'simple' => [
                    '1_4,1_4,1_4,1_4' => 2,
                    '1_5,1_5,1_5,1_5,1_5' => 3,
                    '1_6,1_6,1_6,1_6,1_6,1_6' => 3
                ],
                'complex' => [
                    '1_4,1_4,1_2' => '2',
                    '1_2,1_4,1_4' => '3',
                    '1_5,1_5,3_5' => '2',
                    '3_5,1_5,1_5' => '3',
                    '1_6,1_6,1_6,1_2' => '3',
                    '1_2,1_6,1_6,1_6' => '4'
                ],
            ];
            $column_structure = isset($props['column_structure']) ? $props['column_structure'] : '';
            $columns_arr = explode(',', $column_structure);
            $total_columns = count($columns_arr);
            $column_class = ".et_pb_column.et_pb_column_".strtok($column_structure, ',');
            // Dekstop Custom Gutter Width
            $dekstop_simple_columns = $divi_desktop_columns['simple'];
            if (in_array($column_structure, array_keys($dekstop_simple_columns))) {
                ET_Builder_Element::set_style($render_slug, [
                    'selector' => "%%order_class%% $column_class",
                    'declaration' => "width: calc((100% / $total_columns) - $custom_gutter_value + ($custom_gutter_value / $total_columns)) !important;margin-right: $custom_gutter_value !important;",
                    'media_query' => ET_Builder_Element::get_media_query('min_width_981'),
                ]);
                ET_Builder_Element::set_style($render_slug, [
                    'selector' => "%%order_class%% $column_class:nth-child({$total_columns}n)",
                    'declaration' => "margin-right:0 !important;",
                    'media_query' => ET_Builder_Element::get_media_query('min_width_981'),
                ]);
            }
            $dekstop_complex_columns = $divi_desktop_columns['complex'];
            if (is_array($columns_arr) && in_array($column_structure, array_keys($dekstop_complex_columns))) {
                $d_columns_arr = array_values(array_unique($columns_arr));
                if (isset($d_columns_arr[0]) && isset($d_columns_arr[1])) {
                    $first_index_col = $d_columns_arr[0];
                    $second_index_col = $d_columns_arr[1];
                    ET_Builder_Element::set_style($render_slug, [
                        'selector' => "%%order_class%% .et_pb_column.et_pb_column_$first_index_col",
                        'declaration' => "width: calc(".substr($first_index_col, '0', 1)." * (100% - ($custom_gutter_value * ($total_columns-1))) / ".substr($first_index_col, '2', 1).") !important; margin-right: $custom_gutter_value !important;",
                        'media_query' => ET_Builder_Element::get_media_query('min_width_981'),
                    ]);
                    ET_Builder_Element::set_style($render_slug, [
                        'selector' => "%%order_class%% .et_pb_column.et_pb_column_$second_index_col",
                        'declaration' => "width: calc(".substr($second_index_col, '0', 1)." * (100% - ($custom_gutter_value * ($total_columns-1))) / ".substr($second_index_col, '2', 1).") !important;margin-right: $custom_gutter_value !important;",
                        'media_query' => ET_Builder_Element::get_media_query('min_width_981'),
                    ]);
                }
            }
            // Tablet Custom Gutter Width
            $is_responsive = et_pb_responsive_options()->is_responsive_enabled($props, 'pac_drh_custom_gutter_value');
            $custom_gutter_value_tablet = isset($props['pac_drh_custom_gutter_value_tablet']) ? $props['pac_drh_custom_gutter_value_tablet'] : '';
            if ($is_responsive && !empty($custom_gutter_value_tablet)) {
                $tablet_simple_columns = $divi_tablet_columns['simple'];
                if (in_array($column_structure, array_keys($tablet_simple_columns))) {
                    $total_columns = $total_columns - $tablet_simple_columns[$column_structure];
                    ET_Builder_Element::set_style($render_slug, [
                        'selector' => "%%order_class%% $column_class",
                        'declaration' => "width: calc((100% / $total_columns) - $custom_gutter_value_tablet + ($custom_gutter_value_tablet / $total_columns)) !important;margin-right: $custom_gutter_value_tablet !important;",
                        'media_query' => ET_Builder_Element::get_media_query('pac_drh_min_768_max_980'),
                    ]);
                    ET_Builder_Element::set_style($render_slug, [
                        'selector' => "%%order_class%% $column_class:nth-child({$total_columns}n) ",
                        'declaration' => "margin-right:0 !important;",
                        'media_query' => ET_Builder_Element::get_media_query('pac_drh_min_768_max_980'),
                    ]);
                }
                $tablet_complex_columns = $divi_tablet_columns['complex'];
                if (is_array($columns_arr) && in_array($column_structure, array_keys($tablet_complex_columns))) {
                    $t_columns_arr = array_unique(array_intersect($columns_arr, array_unique(array_diff_key($columns_arr, array_unique($columns_arr)))));
                    $t_columns_arr = array_values(array_unique($t_columns_arr));
                    if (isset($t_columns_arr[0])) {
                        $total_columns = $total_columns - 1;
                        $last_child_numb = $tablet_complex_columns[$column_structure];
                        $index_col = $t_columns_arr[0];
                        ET_Builder_Element::set_style($render_slug, [
                            'selector' => "%%order_class%% .et_pb_column.et_pb_column_$index_col",
                            'declaration' => "width: calc((100% / $total_columns) - $custom_gutter_value_tablet + ($custom_gutter_value_tablet / $total_columns)) !important; margin-right: $custom_gutter_value_tablet !important;",
                            'media_query' => ET_Builder_Element::get_media_query('pac_drh_min_768_max_980'),
                        ]);
                        ET_Builder_Element::set_style($render_slug, [
                            'selector' => "%%order_class%% .et_pb_column.et_pb_column_$index_col:nth-child({$last_child_numb}n) ",
                            'declaration' => "margin-right: 0 !important;",
                            'media_query' => ET_Builder_Element::get_media_query('pac_drh_min_768_max_980'),
                        ]);
                    }
                }
            }
        }

        return $output;
    }

    add_filter('et_module_shortcode_output', 'pac_drh_filter_row_output', 10, 3);
}