<?php
/**
 * Add Custom Toggles
 *
 * @param $modules
 * @param $post_type
 *
 * @return mixed
 */
if (!function_exists('pac_drh_filter_crosssells_toggles')) {
    function pac_drh_filter_crosssells_toggles($modules, $post_type)
    {
        static $is_applied = false;
        if ($is_applied) {
            return $modules;
        }
        if (empty($modules)) {
            return $modules;
        }
        foreach ($modules as $module_slug => $module) {
            if ('et_pb_wc_cross_sells' === $module_slug) {
                if (!isset($module->settings_modal_toggles) || !isset($module->fields_unprocessed)) {
                    continue;
                }
                $toggles_list = $module->settings_modal_toggles;
                if (isset($toggles_list['general']) && !empty($toggles_list['general']['toggles'])) {
                    $toggles_list['general']['toggles']['divi_responsive_helper'] = [
                        'title' => __('Divi Responsive Helper', 'Divi'),
                        'priority' => 15,
                    ];
                    $module->settings_modal_toggles = $toggles_list;
                }
            }
        }
        $is_applied = true;

        return $modules;
    }

    add_filter('et_builder_get_parent_modules', 'pac_drh_filter_crosssells_toggles', 10, 2);
}
/**
 * Filter Fields
 *
 * @param $fields_unprocessed
 *
 * @return array
 */
if (!function_exists('pac_drh_filter_crosssells_fields')) {
    function pac_drh_filter_crosssells_fields($fields_unprocessed)
    {
        $custom_fields = [];
        $custom_fields['columns_number'] = [
            'label' => esc_html__('Column Layout', 'et_builder'),
            'type' => 'select',
            'option_category' => 'layout',
            'options' => [
                '6' => sprintf(esc_html__('%1$s Columns', 'et_builder'), esc_html('6')),
                '5' => sprintf(esc_html__('%1$s Columns', 'et_builder'), esc_html('5')),
                '4' => sprintf(esc_html__('%1$s Columns', 'et_builder'), esc_html('4')),
                '3' => sprintf(esc_html__('%1$s Columns', 'et_builder'), esc_html('3')),
                '2' => sprintf(esc_html__('%1$s Columns', 'et_builder'), esc_html('2')),
                '1' => esc_html__('1 Column', 'et_builder'),
            ],
            'mobile_options' => true,
            'default' => '2',
            'description' => esc_html__('Choose how many columns to display.', 'et_builder'),
            'toggle_slug' => 'divi_responsive_helper',
        ];

        return wp_parse_args($custom_fields, $fields_unprocessed);
    }

    add_filter('et_pb_all_fields_unprocessed_et_pb_wc_cross_sells', 'pac_drh_filter_crosssells_fields');
}
/**
 * Filter Output
 *
 * @param $output
 * @param $render_slug
 * @param $module
 *
 * @return array|mixed|string|string[]|null
 */
if (!function_exists('pac_drh_filter_crosssells_output')) {
    function pac_drh_filter_crosssells_output($output, $render_slug, $module)
    {
        if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
            return $output;
        }
        if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
            return $output;
        }
        if (is_admin() || wp_doing_ajax() || is_array($output)) {
            return $output;
        }
        if ('et_pb_wc_cross_sells' !== $render_slug) {
            return $output;
        }
        // D:2 T:3 P:1
        $margin_between = "4%";
        $columns_number = isset($module->props['columns_number']) ? $module->props['columns_number'] : 2;
        $columns_number_class = "products columns-$columns_number";
        $is_columns_number_responsive = et_pb_responsive_options()->is_responsive_enabled($module->props, 'columns_number');
        $columns_number_tablet = isset($module->props['columns_number_tablet']) ? $module->props['columns_number_tablet'] : 'off';
        $columns_number_phone = isset($module->props['columns_number_phone']) ? $module->props['columns_number_phone'] : 'off';
        // Global CSS
        ET_Builder_Element::set_style($render_slug, [
            'selector' => "%%order_class%% ul.products",
            'declaration' => "display: flex; flex-wrap: wrap;",
        ]);
        ET_Builder_Element::set_style($render_slug, [
            'selector' => "%%order_class%% ul.products li.first",
            'declaration' => "clear: none !important;",
        ]);
        // Desktop CSS
        $output = preg_replace("/\bproducts columns-2\b/", "$columns_number_class", $output);
        ET_Builder_Element::set_style($render_slug, [
            'selector' => "%%order_class%% ul.products.columns-$columns_number li.product,%%order_class%% .woocommerce-page ul.products li.product:nth-child(n)",
            'declaration' => "width: calc((100% / $columns_number) - $margin_between + ($margin_between / $columns_number)) !important;margin-right: $margin_between !important;",
            'media_query' => ET_Builder_Element::get_media_query('min_width_981'),
        ]);
        ET_Builder_Element::set_style($render_slug, [
            'selector' => "%%order_class%% ul.products.columns-$columns_number li.product:nth-child({$columns_number}n)",
            'declaration' => "margin-right: 0 !important;",
            'media_query' => ET_Builder_Element::get_media_query('min_width_981'),
        ]);
        // Tablet CSS
        if ($is_columns_number_responsive && 'off' !== $columns_number_tablet && 3 != $columns_number_tablet) {
            $tablet_columns_class = "tablet-columns-$columns_number_tablet";
            $output = preg_replace("/\b$columns_number_class\b/", "$columns_number_class $tablet_columns_class", $output);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => "%%order_class%% ul.products.$tablet_columns_class li.product,%%order_class%% .woocommerce-page ul.products li.product:nth-child(n)",
                'declaration' => "width: calc((100% / $columns_number_tablet) - $margin_between + ($margin_between / $columns_number_tablet)) !important;margin-right: $margin_between !important;",
                'media_query' => ET_Builder_Element::get_media_query('pac_drh_min_768_max_980'),
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => "%%order_class%% ul.products.$tablet_columns_class li.product:nth-child({$columns_number_tablet}n)",
                'declaration' => "margin-right: 0 !important;",
                'media_query' => ET_Builder_Element::get_media_query('pac_drh_min_768_max_980'),
            ]);
        }
        // Phone CSS
        if ($is_columns_number_responsive && 'off' !== $columns_number_phone && $columns_number_phone > 1) {
            $phone_columns_class = "phone-columns-$columns_number_phone";
            $output = preg_replace("/\b$columns_number_class\b/", "$columns_number_class $phone_columns_class", $output);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => "%%order_class%% ul.products.$phone_columns_class li.product,%%order_class%% .woocommerce-page ul.products li.product:nth-child(n)",
                'declaration' => "width: calc((100% / $columns_number_phone) - $margin_between + ($margin_between / $columns_number_phone)) !important;margin-right: $margin_between !important;",
                'media_query' => ET_Builder_Element::get_media_query('pac_drh_max_767'),
            ]);
            ET_Builder_Element::set_style($render_slug, [
                'selector' => "%%order_class%% ul.products.$phone_columns_class li.product:nth-child({$columns_number_phone}n)",
                'declaration' => "margin-right: 0 !important;",
                'media_query' => ET_Builder_Element::get_media_query('pac_drh_max_767'),
            ]);
        }

        return $output;
    }

    add_filter('et_module_shortcode_output', 'pac_drh_filter_crosssells_output', 10, 3);
}