<?php
/**
 * Filter Output
 *
 * @param $output
 * @param $render_slug
 * @param $module
 *
 * @return array|mixed|string|string[]|null
 */
if (!function_exists('pac_drh_add_class_to_column')) {
    function pac_drh_add_class_to_column($output, $render_slug, $module)
    {
        if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
            return $output;
        }
        if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
            return $output;
        }
        if (is_admin() || wp_doing_ajax() || is_array($output)) {
            return $output;
        }
        if ('et_pb_column' !== $render_slug && 'et_pb_column_inner' !== $render_slug) {
            return $output;
        }
        $staking_order_tab = isset($module->props['pac_drh_add_staking_order_tab']) ? $module->props['pac_drh_add_staking_order_tab'] : 'off';
        $staking_order_mob = isset($module->props['pac_drh_add_staking_order_mob']) ? $module->props['pac_drh_add_staking_order_mob'] : 'off';
        if ('off' !== $staking_order_tab) {
            $output = preg_replace("/\b$render_slug\b/", "$render_slug {$module->props['pac_drh_add_staking_order_tab']}", $output);
        }
        if ('off' !== $staking_order_mob) {
            $output = preg_replace("/\b$render_slug\b/", "$render_slug {$module->props['pac_drh_add_staking_order_mob']}", $output);
        }

        return $output;
    }

    add_filter('et_module_shortcode_output', 'pac_drh_add_class_to_column', 10, 3);
}
