<?php
/**
 * Filter Fields
 *
 * @param $fields_unprocessed
 *
 * @return array
 */
if (!function_exists('pac_drh_filter_blurb_fields')) {
    function pac_drh_filter_blurb_fields($fields_unprocessed)
    {
        global $shortname;
        $custom_fields = [];
        $custom_fields['pac_drh_blurb_layout_phone'] = [
            'label' => __('Blurb Image/Icon Position On Phone', $shortname),
            'type' => 'select',
            'options' => [
                'off' => __('Default', $shortname),
                'pac_drh_ph_blurb_top_left' => __('Top Left', $shortname),
                'pac_drh_ph_blurb_top_center' => __('Top Center', $shortname),
                'pac_drh_ph_blurb_top_right' => __('Top Right', $shortname),
            ],
            'default' => 'off',
            'description' => __('Choose the image or icon position on Phone devices when the default placement is set to left.', $shortname),
            'tab_slug' => 'advanced',
            'toggle_slug' => 'icon_settings',
            'show_if' => [
                'icon_placement' => 'left'
            ]
        ];

        return wp_parse_args($custom_fields, $fields_unprocessed);
    }

    add_filter('et_pb_all_fields_unprocessed_et_pb_blurb', 'pac_drh_filter_blurb_fields');
}
/**
 * Filter Output
 *
 * @param $output
 * @param $render_slug
 * @param $module
 *
 * @return array|mixed|string|string[]|null
 */
if (!function_exists('pac_drh_filter_blurb_output')) {
    function pac_drh_filter_blurb_output($output, $render_slug, $module)
    {
        if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
            return $output;
        }
        if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
            return $output;
        }
        if (is_admin() || wp_doing_ajax() || is_array($output)) {
            return $output;
        }
        if ('et_pb_blurb' !== $render_slug) {
            return $output;
        }
        $blurb_layout_phone = isset($module->props['pac_drh_blurb_layout_phone']) ? $module->props['pac_drh_blurb_layout_phone'] : 'off';
        if ('off' !== $blurb_layout_phone) {
            $output = preg_replace('/\bet_pb_module\b/', 'et_pb_module '.$blurb_layout_phone, $output);
        }

        return $output;
    }

    add_filter('et_module_shortcode_output', 'pac_drh_filter_blurb_output', 10, 3);
}
/**
 * Blurb Inline CSS
 */
if (!function_exists('pac_drh_blurb_css')) {
    function pac_drh_blurb_css()
    {
        echo PHP_EOL;
        echo "<style id='pac-drh-blurb-inline-css'>";
        echo '@media all and (max-width:767px){.pac_drh_ph_blurb_top_left.et_pb_blurb_position_left .et_pb_main_blurb_image{display:block!important}.pac_drh_ph_blurb_top_left.et_pb_blurb_position_left .et_pb_blurb_container{padding-left:0;display:block!important}.pac_drh_ph_blurb_top_center.et_pb_blurb_position_left .et_pb_main_blurb_image{display:block!important;width:50%;margin:0 auto;margin-bottom:30px}.pac_drh_ph_blurb_top_center.et_pb_blurb_position_left .et_pb_blurb_container{padding-left:0;display:block!important}.pac_drh_ph_blurb_top_right.et_pb_blurb_position_left .et_pb_main_blurb_image{margin-left:auto;display:flex;flex-direction:row-reverse}.pac_drh_ph_blurb_top_right.et_pb_blurb_position_left .et_pb_blurb_container{padding-left:0;display:block!important}}';
        echo "</style>";
        echo PHP_EOL;
    }

    add_action('admin_print_styles', 'pac_drh_blurb_css');
    add_action('wp_print_styles', 'pac_drh_blurb_css');
}
