<?php
/**
 * Add Tab
 *
 * @param $tabs
 *
 * @return array
 */
if (!function_exists('pac_drh_epanel_tabs')) {
    function pac_drh_epanel_tabs($tabs)
    {
        global $shortname;

        return array_merge($tabs, ['drh' => __('Divi Responsive Helper', $shortname)]);
    }

    add_filter("et_epanel_tab_names", 'pac_drh_epanel_tabs');
}
/**
 * Add Fields
 *
 * @param $options
 *
 * @return mixed
 */
if (!function_exists('pac_drh_epanel_fields')) {
    function pac_drh_epanel_fields($options)
    {
        global $shortname;
        $options[] = [
            "name" => "wrap-drh",
            "type" => "contenttab-wrapstart",
        ];
        $options[] = [
            "type" => "subnavtab-start",
        ];
        $options[] = [
            "name" => "drh-1",
            "type" => "subnav-tab",
            "desc" => esc_html__("Preview Size", $shortname)
        ];
        $options[] = [
            "name" => "drh-2",
            "type" => "subnav-tab",
            "desc" => esc_html__("Widow Fixer", $shortname)
        ];
        $options[] = [
            "name" => "drh-3",
            "type" => "subnav-tab",
            "desc" => esc_html__("Column Stacking", $shortname)
        ];
        $options[] = [
            "name" => "drh-4",
            "type" => "subnav-tab",
            "desc" => esc_html__("Typography", $shortname)
        ];
        $options[] = [
            "name" => "drh-5",
            "type" => "subnav-tab",
            "desc" => esc_html__("Menu", $shortname)
        ];
        $options[] = [
            "name" => "drh-6",
            "type" => "subnav-tab",
            "desc" => esc_html__("CSS Media Queries", $shortname)
        ];
        $options[] = [
            "name" => "drh-7",
            "type" => "subnav-tab",
            "desc" => esc_html__("Layout", $shortname)
        ];
        $options[] = [
            "name" => "drh-8",
            "type" => "subnav-tab",
            "desc" => esc_html__("Miscellaneous", $shortname)
        ];
        $options[] = [
            "name" => "drh-9",
            "type" => "subnav-tab",
            "desc" => esc_html__("Plugin Data", $shortname)
        ];
        $options[] = [
            "type" => "subnavtab-end",
        ];
        $options[] = [
            "name" => "drh-1",
            "type" => "subcontent-start",
        ];
        $options[] = [
            "name" => esc_html__('Preview Size Presets', $shortname),
            "id" => "pac_drh_enable_presets",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to show the preview size preset buttons in the Visual Builder page settings (located in the bottom left corner by default).", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Phone Preset Button One', $shortname),
            "id" => "pac_drh_phone_preset_one",
            "type" => "text",
            "std" => "320",
            "desc" => esc_html__("Enter a custom value for the 1st preview size preset button in the Phone view.", $shortname),
            "validation_type" => "number"
        ];
        $options[] = [
            "name" => esc_html__('Phone Preset Button Two', $shortname),
            "id" => "pac_drh_phone_preset_two",
            "type" => "text",
            "std" => "479",
            "desc" => esc_html__("Enter a custom value for the 2nd preview size preset button in the Phone view.", $shortname),
            "validation_type" => "number"
        ];
        $options[] = [
            "name" => esc_html__('Phone Preset Button Three', $shortname),
            "id" => "pac_drh_phone_preset_three",
            "type" => "text",
            "std" => "767",
            "desc" => esc_html__("Enter a custom value for the 3rd preview size preset button in the Phone view.", $shortname),
            "validation_type" => "number"
        ];
        $options[] = [
            "name" => esc_html__('Tablet Preset Button One', $shortname),
            "id" => "pac_drh_tablet_preset_one",
            "type" => "text",
            "std" => "768",
            "desc" => esc_html__("Enter a custom value for the 1st preview size preset button in the Tablet view.", $shortname),
            "validation_type" => "number"
        ];
        $options[] = [
            "name" => esc_html__('Tablet Preset Button Two', $shortname),
            "id" => "pac_drh_tablet_preset_two",
            "type" => "text",
            "std" => "880",
            "desc" => esc_html__("Enter a custom value for the 2nd preview size preset button in the Tablet view.", $shortname),
            "validation_type" => "number"
        ];
        $options[] = [
            "name" => esc_html__('Tablet Preset Button Three', $shortname),
            "id" => "pac_drh_tablet_preset_three",
            "type" => "text",
            "std" => "980",
            "desc" => esc_html__("Enter a custom value for the 3rd preview size preset button in the Tablet view.", $shortname),
            "validation_type" => "number"
        ];
        $options[] = [
            "name" => esc_html__('Desktop Preset Button One', $shortname),
            "id" => "pac_drh_desktop_preset_one",
            "type" => "text",
            "std" => "982",
            "desc" => esc_html__("Enter a custom value for the 1st preview size preset button in the Desktop view.", $shortname),
            "validation_type" => "number"
        ];
        $options[] = [
            "name" => esc_html__('Desktop Preset Button Two', $shortname),
            "id" => "pac_drh_desktop_preset_two",
            "type" => "text",
            "std" => "1024",
            "desc" => esc_html__("Enter a custom value for the 2nd preview size preset button in the Desktop view.", $shortname),
            "validation_type" => "number"
        ];
        $options[] = [
            "name" => esc_html__('Desktop Preset Button Three', $shortname),
            "id" => "pac_drh_desktop_preset_three",
            "type" => "text",
            "std" => "1200",
            "desc" => esc_html__("Enter a custom value for the 3rd preview size preset button in the Desktop view.", $shortname),
            "validation_type" => "number"
        ];
        $options[] = [
            "name" => esc_html__('Preview Size Custom Value', $shortname),
            "id" => "pac_drh_enable_custom_preview",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => 'Enable this feature to show the preview size custom value field in the Visual Builder page settings (located in the bottom left corner by default).',
        ];
        $options[] = [
            "name" => esc_html__('Disable Divi Responsive Views Settings', $shortname),
            "id" => "pac_drh_enable_hide_responsive_view",
            "type" => "checkbox2",
            "std" => "on",
            "desc" => esc_html__("Enable this feature to completely remove the default Divi Responsive Views settings.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Show Viewport Size', $shortname),
            "id" => "pac_drh_enable_view_port_size",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to add the current viewport width and height size in the Visual Builder page settings.", $shortname),
        ];
        $options[] = [
            "name" => "drh-1",
            "type" => "subcontent-end",
        ];
        $options[] = [
            "name" => "drh-2",
            "type" => "subcontent-start",
        ];
        $options[] = [
            "name" => esc_html__('Widow Fixer', $shortname),
            "id" => "pac_drh_enable_widow_fixer",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable the Widow Fixer feature.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Paragraphs', $shortname),
            "id" => "pac_drh_enable_paragraph_widow_fixer",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to remove the widow words on the last line of paragraph text.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Minimum Paragraph Widow Words', $shortname),
            "id" => "pac_drh_widow_fixer_paragraph_select",
            "type" => "select",
            "std" => "asc",
            "options" => [2, 3, 4],
            "desc" => esc_html__(" Select the minimum number of words allowed on the last line of each paragraph.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Headings', $shortname),
            "id" => "pac_drh_widow_fixer_headings",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable the Widow Fixer feature for headings (H1-H6).", $shortname),
            "class" => 'my_class',
        ];
        $options[] = [
            "name" => esc_html__('Minimum Heading Widow Words', $shortname),
            "id" => "pac_drh_widow_fixer_heading_select",
            "type" => "select",
            "std" => "asc",
            "options" => [2, 3, 4],
            "desc" => esc_html__(" Select the minimum number of words allowed on the last line of each heading.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Exclude Pages', $shortname),
            "id" => "pac_drh_enable_pages_widow_fixer",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to excluded the Widow Fixer on selected pages.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Select Pages To Exclude', $shortname),
            "id" => "pac_drh_pages_widow_fixer",
            "type" => "checkboxes",
            "desc" => esc_html__("Choose which pages you want to include or exclude from the Widow Fixer settings. The Widow Fixer will apply to all pages marked with a checkmark, and all pages marked with an X will be excluded.",
                $shortname),
            "usefor" => "pages",
            "options" => pac_drh_get_pages_list(),
        ];
        $options[] = [
            "name" => esc_html__('Exclude Sections, Rows, or Modules', $shortname),
            "id" => "pac_drh_exclude_widow_fixer",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("This feature requires you to add a CSS class to the section, row, or module that you want to exclude from the Widow Fixer. To do this, simply open the settings of that element and go to the Advanced tab. There you will see a toggle called CSS ID & Classes. Open that toggle and place the CSS class “exclude-drh-widow-fixer” into the CSS Class input field.",
                $shortname),
        ];
        $options[] = [
            "name" => "drh-2",
            "type" => "subcontent-end",
        ];
        $options[] = [
            "name" => "drh-3",
            "type" => "subcontent-start",
        ];
        $options[] = [
            "name" => esc_html__('Row Column Stacking Order', $shortname),
            "id" => "pac_drh_enable_col_stacking",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to activate the additional settings located in the Advanced tab of the Divi Builder Row and Column settings for choosing the order in which columns stack on each device.",
                $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Row Number of Columns', $shortname),
            "id" => "pac_drh_enable_number_of_columns",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to activate the additional settings located in the Advanced tab of the Divi Builder Row settings for choosing the number of columns to show on each device. ",
                $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Blog Module Number of Columns', $shortname),
            "id" => "pac_drh_enable_blog_number_of_columns",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to activate the additional settings located in the Design tab of the Divi Blog module settings when the Grid Layout is used for choosing the number of blog columns to show on each device.",
                $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Portfolio Modules Number of Columns', $shortname),
            "id" => "pac_drh_enable_portfolio_number_of_columns",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to activate the additional settings located in the Design tab of both the Divi Portfolio module and Divi Filterable Portfolio module settings when the Grid Layout is used for choosing the number of portfolio columns to show on each device.",
                $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Gallery Module Number of Columns', $shortname),
            "id" => "pac_drh_enable_gallery_number_of_columns",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to activate the additional settings located in the Design tab of the Divi Gallery module settings when the Grid Layout is used for choosing the number of image columns to show on each device.",
                $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Woo Products Module Number of Columns', $shortname),
            "id" => "pac_drh_enable_shop_number_of_columns",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to activate the additional settings located in the Content tab of the Divi Woo Products module settings for choosing the number of product columns to show on each device.",
                $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Woo Related Products Module Number of Columns', $shortname),
            "id" => "pac_drh_enable_related_products_number_of_columns",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to activate the missing responsive number of columns of the Divi Woo Related Products module settings for choosing the number of product columns to show on each device.",
                $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Woo Cross Sells Module Number of Columns', $shortname),
            "id" => "pac_drh_enable_crosssells_number_of_columns",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to activate the missing responsive number of columns of the Divi Woo Cross Sells module settings for choosing the number of product columns to show on each device.",
                $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Woo Product Upsell Module Number of Columns', $shortname),
            "id" => "pac_drh_enable_upsells_number_of_columns",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to activate the missing responsive number of columns of the Divi Woo Product Upsell module settings for choosing the number of product columns to show on each device.",
                $shortname),
        ];
        $options[] = [
            "name" => "drh-3",
            "type" => "subcontent-end",
        ];
        $options[] = [
            "name" => "drh-4",
            "type" => "subcontent-start",
        ];
        $options[] = [
            "name" => esc_html__('Text Sizes', $shortname),
            "id" => "pac_drh_enable_text_sizes",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to set the heading (H1, H2, H3, H4, H5, H6) and paragraph text sizes to apply across the entire website on Desktop, Tablet, and Phone.",
                $shortname),
        ];
        $desktop_heading = absint(et_get_option('body_header_size', '42'));
        $tablet_heading = absint(et_get_option('tablet_header_font_size', '38'));
        $phone_heading = absint(et_get_option('phone_header_font_size', '34'));
        $heading_line_height = floatval(et_get_option('body_font_height', '1.7'));
        $options[] = [
            "name" => esc_html__('H1 Heading Text Size - Desktop', $shortname),
            "id" => "pac_drh_h1_desktop",
            "type" => "text",
            "std" => $desktop_heading.'px',
            "desc" => esc_html__("Set the H1 heading text size value and unit to apply across the entire website on Desktop.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H1 Heading Text Size - Tablet', $shortname),
            "id" => "pac_drh_h1_tablet",
            "type" => "text",
            "std" => $tablet_heading.'px',
            "desc" => esc_html__("Set the H1 heading text size value and unit to apply across the entire website on Tablet.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H1 Heading Text Size - Phone', $shortname),
            "id" => "pac_drh_h1_phone",
            "type" => "text",
            "std" => $phone_heading.'px',
            "desc" => esc_html__("Set the H1 heading text size value and unit to apply across the entire website on Phone.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H1 Heading Line Height', $shortname),
            "id" => "pac_drh_h1_line_height",
            "type" => "text",
            "std" => $heading_line_height.'em',
            "desc" => esc_html__("Set the H1 heading line height value and unit to apply across the entire website.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H2 Heading Text Size - Desktop', $shortname),
            "id" => "pac_drh_h2_desktop",
            "type" => "text",
            "std" => esc_html(intval($desktop_heading * .86)).'px',
            "desc" => esc_html__("Set the H2 heading text size value and unit to apply across the entire website on Desktop.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H2 Heading Text Size - Tablet', $shortname),
            "id" => "pac_drh_h2_tablet",
            "type" => "text",
            "std" => esc_html(intval($tablet_heading * .86)).'px',
            "desc" => esc_html__("Set the H2 heading text size value and unit to apply across the entire website on Tablet.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H2 Heading Text Size - Phone', $shortname),
            "id" => "pac_drh_h2_phone",
            "type" => "text",
            "std" => esc_html(intval($phone_heading * .86)).'px',
            "desc" => esc_html__("Set the H2 heading text size value and unit to apply across the entire website on Phone.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H2 Heading Line Height', $shortname),
            "id" => "pac_drh_h2_line_height",
            "type" => "text",
            "std" => $heading_line_height * .86 .'em',
            "desc" => esc_html__("Set the H2 heading line height value and unit to apply across the entire website.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H3 Heading Text Size - Desktop', $shortname),
            "id" => "pac_drh_h3_desktop",
            "type" => "text",
            "std" => esc_html(intval($desktop_heading * .73)).'px',
            "desc" => esc_html__("Set the H3 heading text size value and unit to apply across the entire website on Desktop.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H3 Heading Text Size - Tablet', $shortname),
            "id" => "pac_drh_h3_tablet",
            "type" => "text",
            "std" => esc_html(intval($tablet_heading * .73)).'px',
            "desc" => esc_html__("Set the H3 heading text size value and unit to apply across the entire website on Tablet.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H3 Heading Text Size - Phone', $shortname),
            "id" => "pac_drh_h3_phone",
            "type" => "text",
            "std" => esc_html(intval($phone_heading * .73)).'px',
            "desc" => esc_html__("Set the H3 heading text size value and unit to apply across the entire website on Phone.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H3 Heading Line Height', $shortname),
            "id" => "pac_drh_h3_line_height",
            "type" => "text",
            "std" => $heading_line_height * .73 .'em',
            "desc" => esc_html__("Set the H3 heading line height value and unit to apply across the entire website.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H4 Heading Text Size - Desktop', $shortname),
            "id" => "pac_drh_h4_desktop",
            "type" => "text",
            "std" => esc_html(intval($desktop_heading * .6)).'px',
            "desc" => esc_html__("Set the H4 heading text size value and unit to apply across the entire website on Desktop.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H4 Heading Text Size - Tablet', $shortname),
            "id" => "pac_drh_h4_tablet",
            "type" => "text",
            "std" => esc_html(intval($tablet_heading * .6)).'px',
            "desc" => esc_html__("Set the H4 heading text size value and unit to apply across the entire website on Tablet.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H4 Heading Text Size - Phone', $shortname),
            "id" => "pac_drh_h4_phone",
            "type" => "text",
            "std" => esc_html(intval($phone_heading * .6)).'px',
            "desc" => esc_html__("Set the H4 heading text size value and unit to apply across the entire website on Phone.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H4 Heading Line Height', $shortname),
            "id" => "pac_drh_h4_line_height",
            "type" => "text",
            "std" => $heading_line_height * .6 .'em',
            "desc" => esc_html__("Set the H4 heading line height value and unit to apply across the entire website.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H5 Heading Text Size - Desktop', $shortname),
            "id" => "pac_drh_h5_desktop",
            "type" => "text",
            "std" => esc_html(intval($desktop_heading * .53)).'px',
            "desc" => esc_html__("Set the H5 heading text size value and unit to apply across the entire website on Desktop.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H5 Heading Text Size - Tablet', $shortname),
            "id" => "pac_drh_h5_tablet",
            "type" => "text",
            "std" => esc_html(intval($tablet_heading * .53)).'px',
            "desc" => esc_html__("Set the H5 heading text size value and unit to apply across the entire website on Tablet.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H5 Heading Text Size - Phone', $shortname),
            "id" => "pac_drh_h5_phone",
            "type" => "text",
            "std" => esc_html(intval($phone_heading * .53)).'px',
            "desc" => esc_html__("Set the H5 heading text size value and unit to apply across the entire website on Phone.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H5 Heading Line Height', $shortname),
            "id" => "pac_drh_h5_line_height",
            "type" => "text",
            "std" => $heading_line_height * .53 .'em',
            "desc" => esc_html__("Set the H5 heading line height value and unit to apply across the entire website.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H6 Heading Text Size - Desktop', $shortname),
            "id" => "pac_drh_h6_desktop",
            "type" => "text",
            "std" => esc_html(intval($desktop_heading * .47)).'px',
            "desc" => esc_html__("Set the H6 heading text size value and unit to apply across the entire website on Desktop.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H6 Heading Text Size - Tablet', $shortname),
            "id" => "pac_drh_h6_tablet",
            "type" => "text",
            "std" => esc_html(intval($tablet_heading * .47)).'px',
            "desc" => esc_html__("Set the H6 heading text size value and unit to apply across the entire website on Tablet.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H6 Heading Text Size - Phone', $shortname),
            "id" => "pac_drh_h6_phone",
            "type" => "text",
            "std" => esc_html(intval($phone_heading * .47)).'px',
            "desc" => esc_html__("Set the H6 heading text size value and unit to apply across the entire website on Phone.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('H6 Heading Line Height', $shortname),
            "id" => "pac_drh_h6_line_height",
            "type" => "text",
            "std" => $heading_line_height * .47 .'em',
            "desc" => esc_html__("Set the H6 heading line height value and unit to apply across the entire website.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Paragraph Text Size - Desktop', $shortname),
            "id" => "pac_drh_p_desktop",
            "type" => "text",
            "std" => absint(et_get_option('body_font_size', '20')).'px',
            "desc" => esc_html__("Set the paragraph text size value and unit to apply across the entire website on Desktop.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Paragraph Text Size - Tablet', $shortname),
            "id" => "pac_drh_p_tablet",
            "type" => "text",
            "std" => absint(et_get_option('tablet_body_font_size', '18')).'px',
            "desc" => esc_html__("Set the paragraph text size value and unit to apply across the entire website on Tablet.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Paragraph Text Size - Phone', $shortname),
            "id" => "pac_drh_p_phone",
            "type" => "text",
            "std" => absint(et_get_option('phone_body_font_size', '16')).'px',
            "desc" => esc_html__("Set the paragraph text size value and unit to apply across the entire website on Phone.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Paragraph Line Height', $shortname),
            "id" => "pac_drh_p_line_height",
            "type" => "text",
            "std" => $heading_line_height.'em',
            "desc" => esc_html__("Set the paragraph line height value and unit to apply across the entire website.", $shortname),
        ];
        $options[] = [
            "name" => "drh-4",
            "type" => "subcontent-end",
        ];
        $options[] = [
            "name" => "drh-5",
            "type" => "subcontent-start",
        ];
        $options[] = [
            "name" => esc_html__('Enable Settings In Menu Module', $shortname),
            "id" => "pac_drh_enable_menu_module_settings",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Choose to enable all the menu related settings in the Divi Menu module.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Show/Hide Menu Items Per Device', $shortname),
            "id" => "pac_drh_enable_show_hide_menu_item",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to add new checkmarks in the WordPress navigation menu items to show or hide the menu items on Desktop, Tablet, or Phone.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Show X Icon When Opened', $shortname),
            "id" => "pac_drh_enable_open_mobile_icon",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Change the mobile menu hamburger icon to an X when the menu it is toggled open.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Show A Hamburger Menu On Desktop', $shortname),
            "id" => "pac_drh_enable_hamburger_menu_desktop",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Choose to replace the open Desktop menu with a hamburger menu instead.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Add Text Beside Hamburger Menu Icon', $shortname),
            "id" => "pac_drh_enable_hamburger_menu_text",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Add custom text to the left side of the hamburger menu icon.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Hamburger Menu Text', $shortname),
            "id" => "pac_drh_hamburger_header_menu_text",
            "type" => "text",
            "std" => __('Menu', $shortname),
            "desc" => esc_html__("Enter custom text to show on the left side of the hamburger menu.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Collapse Mobile Menu Submenus', $shortname),
            "id" => "pac_drh_enable_collapse_mobile_submenus",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Choose to collapse the submenu by default.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Collapse Submenu When Another Is Opened', $shortname),
            "id" => "pac_drh_enable_collapse_other_submenus",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Choose to collapse the open submenu when another submenu is opened.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Open/Close Submenus By Clicking Parent Menu Item', $shortname),
            "id" => "pac_drh_openclose_submenu_with_parent",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Choose to open and close the submenu by clicking the parent menu item. This effectively disables the parent menu link.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Fixed Navigation Bar On Mobile', $shortname),
            "id" => "pac_drh_fixed_navigation_bar",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this setting to make the header menu navigation bar stay fixed at the top of the screen on Tablet and Phone device sizes.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Menu Breakpoint', $shortname),
            "id" => "pac_drh_menu_breakpoint",
            "type" => "text",
            "std" => "",
            "desc" => esc_html__("Enter the screen width pixel value for the responsive breakpoint for when the menu changes between desktop and mobile versions. The default value in Divi is 981px.",
                $shortname),
        ];
        $options[] = [
            "name" => "drh-5",
            "type" => "subcontent-end",
        ];
        $options[] = [
            "name" => "drh-6",
            "type" => "subcontent-start",
        ];
        $options[] = [
            "name" => esc_html__("Custom CSS For Desktop Only", $shortname),
            "id" => "pac_drh_desktop_media_query",
            "type" => "textarea",
            "std" => "",
            "desc" => esc_html__("Place any custom CSS here that you want to apply on Desktop device sizes only (981px and up).", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__("Custom CSS For Tablet Only", $shortname),
            "id" => "pac_drh_tablet_media_query",
            "type" => "textarea",
            "std" => "",
            "desc" => esc_html__("Place any custom CSS here that you want to apply on Tablet device sizes only (767px - 980px).", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__("Custom CSS For Phone Only", $shortname),
            "id" => "pac_drh_phone_media_query",
            "type" => "textarea",
            "std" => "",
            "desc" => esc_html__("Place any custom CSS here that you want to apply on Phone device sizes only (0px - 767px).", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__("Custom CSS For Desktop And Tablet Only", $shortname),
            "id" => "pac_drh_desktop_tablet_media_query",
            "type" => "textarea",
            "std" => "",
            "desc" => esc_html__("Place any custom CSS here that you want to apply on Desktop and Tablet device sizes only (0px - 767px).", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__("Custom CSS For Tablet and Phone Only", $shortname),
            "id" => "pac_drh_tablet_phone_media_query",
            "type" => "textarea",
            "std" => "",
            "desc" => esc_html__("Place any custom CSS here that you want to apply on Tablet and Phone device sizes only (0px - 767px).", $shortname),
            "validation_type" => "nohtml"
        ];
        $cmq_counter = 0;
        foreach (pac_drh_custom_media_queries() as $cmq) {
            $cmq_counter++;
            $options[] = [
                'name' => '',
                'id' => 'pac_drh_cmq_divider',
                'type' => 'callback_function',
                'function_name' => function () use ($cmq_counter) {
                    echo "<b>Custom CSS Media Query ".esc_html($cmq_counter)."</b>";
                },
                'desc' => '',
            ];
            $options[] = [
                "name" => esc_html__("Custom Min-Width Value", $shortname),
                "id" => "pac_drh_cmq_min_$cmq",
                "type" => "text",
                "std" => "",
                "desc" => esc_html__("Enter a custom value to set the minimum device size for the code to take effect in the custom media query.", $shortname),
                "validation_type" => "nohtml"
            ];
            $options[] = [
                "name" => esc_html__("Custom Max-Width Value", $shortname),
                "id" => "pac_drh_cmq_max_$cmq",
                "type" => "text",
                "std" => "",
                "desc" => esc_html__("Enter a custom value to set the maximum device size for the code to take effect in the custom media query. ", $shortname),
                "validation_type" => "nohtml"
            ];
            $options[] = [
                "name" => esc_html__("Custom CSS Media Query", $shortname),
                "id" => "pac_drh_cmq_css_$cmq",
                "type" => "textarea",
                "std" => "",
                "desc" => esc_html__("Place any custom CSS here that you want to apply only on device sizes between the custom min-width and max-width values.", $shortname),
                "validation_type" => "nohtml"
            ];
        }
        $options[] = [
            "name" => "drh-6",
            "type" => "subcontent-end",
        ];
        $options[] = [
            "name" => "drh-7",
            "type" => "subcontent-start",
        ];
        $options[] = [
            "name" => esc_html__('Section Default Top/Bottom Padding On Desktop (%)', $shortname),
            "id" => "pac_drh_desktop_section_height",
            "type" => "text",
            "std" => esc_html(et_get_option('section_padding')),
            "desc" => esc_html__("Set the default top and bottom padding percentage value to apply to all sections across the entire website on Desktop.", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__('Section Default Top/Bottom Padding On Tablet (px)', $shortname),
            "id" => "pac_drh_tablet_section_height",
            "type" => "text",
            "std" => esc_html(et_get_option('tablet_section_height')),
            "desc" => esc_html__("Set the default top and bottom padding pixel value to apply to all sections across the entire website on Tablet.", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__('Section Default Top/Bottom Padding On Phone (px)', $shortname),
            "id" => "pac_drh_phone_section_height",
            "type" => "text",
            "std" => esc_html(et_get_option('phone_section_height')),
            "desc" => esc_html__("Set the default top and bottom padding pixel value to apply to all sections across the entire website on Phone.", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__('Row Default Top/Bottom Padding On Desktop (%)', $shortname),
            "id" => "pac_drh_desktop_row_height",
            "type" => "text",
            "std" => esc_html(et_get_option('row_padding')),
            "desc" => esc_html__("Set the default top and bottom padding percentage value to apply to all rows across the entire website on Desktop.", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__('Row Default Top/Bottom Padding On Tablet (px)', $shortname),
            "id" => "pac_drh_tablet_row_height",
            "type" => "text",
            "std" => esc_html(et_get_option('tablet_row_height')),
            "desc" => esc_html__("Set the default top and bottom padding pixel value to apply to all rows across the entire website on Tablet.", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__('Row Default Top/Bottom Padding On Phone (px)', $shortname),
            "id" => "pac_drh_phone_row_height",
            "type" => "text",
            "std" => esc_html(et_get_option('phone_row_height')),
            "desc" => esc_html__("Set the default top and bottom padding pixel value to apply to all rows across the entire website on Phone.", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__('Row Default Width On Desktop (%)', $shortname),
            "id" => "pac_drh_row_width_desktop",
            "type" => "text",
            "std" => "",
            "desc" => esc_html__("Set the default width percentage value to apply to all rows across the entire website on Desktop.", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__('Row Default Width On Tablet (%)', $shortname),
            "id" => "pac_drh_row_width_tablet",
            "type" => "text",
            "std" => "",
            "desc" => esc_html__("Set the default width percentage value to apply to all rows across the entire website on Tablet.", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__('Row Default Width On Phone (%)', $shortname),
            "id" => "pac_drh_row_width_phone",
            "type" => "text",
            "std" => "",
            "desc" => esc_html__("Set the default width percentage value to apply to all rows across the entire website on Phone.", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__('Row Default Max Width On Desktop (px)', $shortname),
            "id" => "pac_drh_row_max_width_desktop",
            "type" => "text",
            "std" => "",
            "desc" => esc_html__("Set the default max-width pixel value to all rows across the entire website on Desktop.", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__('Row Default Max Width On Tablet (px)', $shortname),
            "id" => "pac_drh_row_max_width_tablet",
            "type" => "text",
            "std" => "",
            "desc" => esc_html__("Set the default max-width pixel value to apply to all rows across the entire website on Phone.", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__('Row Default Max Width On Phone (px)', $shortname),
            "id" => "pac_drh_row_max_width_phone",
            "type" => "text",
            "std" => "",
            "desc" => esc_html__("Set the default max-width value and unit to apply to all rows across the entire website on Phone.", $shortname),
            "validation_type" => "nohtml"
        ];
        $options[] = [
            "name" => esc_html__('Custom Gutter Width', $shortname),
            "id" => "pac_drh_enable_custom_gutter_width",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to activate an additional setting in the Divi Builder Rows in the Sizing toggle for setting the custom value and unit for the gutter on any device size.", $shortname),
        ];
        $options[] = [
            "name" => "drh-7",
            "type" => "subcontent-end",
        ];
        $options[] = [
            "name" => "drh-8",
            "type" => "subcontent-start",
        ];
        $options[] = [
            "name" => esc_html__('Blog Module Post Count', $shortname),
            "id" => "pac_drh_enable_responsive_blog_count",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this setting to activate responsive options in the Blog module for setting the post count on Desktop, Tablet, and Phone.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Woo Products Module Product Count', $shortname),
            "id" => "pac_drh_enable_responsive_shop_count",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this setting to activate responsive options in the Woo Products Module for setting the product count on Desktop, Tablet, and Phone.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Gallery Module Image Count', $shortname),
            "id" => "pac_drh_enable_responsive_gallery_count",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this setting to activate responsive options in the Gallery module for setting the image count on Desktop, Tablet, and Phone.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Portfolio Module Project Count', $shortname),
            "id" => "pac_drh_enable_responsive_portfolio_count",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this setting to activate responsive options in the Portfolio module for setting the project count on Desktop, Tablet, and Phone.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Auto Open Responsive Tabs', $shortname),
            "id" => "pac_drh_enable_auto_responsive",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable and this feature to automatically open the responsive Desktop, Tablet and Phone tabs in the Visual Builder.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Disable Hover Effects On Touch Devices', $shortname),
            "id" => "pac_drh_disabled_hover_effects",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to automatically disabled hover effects on touch devices.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Parallax On Mobile Devices', $shortname),
            "id" => "pac_drh_enable_mobile_parallax",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to automatically add support for parallax effect on mobile devices whenever the Use Parallax Effect setting is enabled within any Divi section, row, column, or module.",
                $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Disable Animations On Mobile', $shortname),
            "id" => "pac_drh_enable_remove_animation",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to disable animations on mobile to improve performance.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Prevent Horizontal Scroll', $shortname),
            "id" => "pac_drh_enable_prevent_horizontal_scroll",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to prevent a common issue with Divi which causes the mobile site to scroll sideways with a horizontal scroll bar.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Mobile Pinch Zooming', $shortname),
            "id" => "pac_drh_enable_mobile_pinch_zoom",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to allow users to pinch and zoom on mobile.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__("Mobile Logo", $shortname),
            "id" => "pac_drh_mobile_logo",
            "type" => "upload",
            "button_text" => esc_html__("Set As Logo", $shortname),
            "std" => "",
            "desc" => esc_html__("Set a different logo image to appear in the default header menu on tablet and phone devices.", $shortname),
            "validation_type" => "url",
        ];
        $options[] = [
            "name" => esc_html__("Mobile Header Bar Color", $shortname),
            "id" => "pac_drh_mobile_header_color",
            "type" => "et_color_palette",
            "items_amount" => 1,
            "std" => '#FFFFFF',
            "desc" => esc_html__("Set a color for the mobile address bar header for Android devices using the Chrome browser.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Tabs Module Tab Layout', $shortname),
            "id" => "pac_drh_enable_tabs_layout_settings",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to show settings in the Design tab of the Divi Tabs module for setting the tab stacking layout.", $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Blurb Image/Icon Position On Phone', $shortname),
            "id" => "pac_drh_enable_blurb_settings",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("Enable this feature to activate new settings in the Design tab of the Divi Blurb module settings for setting the blurb image/icon position on Phone devices when the default placement is set to left.",
                $shortname),
        ];
        $options[] = [
            "name" => esc_html__('Back To Top Button Visibility', $shortname),
            "id" => "pac_drh_back_top_visibility",
            "type" => "select",
            "options" => [
                "off" => __("Show On All Devices", $shortname),
                "desktop" => __("Show On Desktop", $shortname),
                "tablet" => __("Show On Tablet", $shortname),
                "phone" => __("Show On Phone", $shortname),
                "desktop_tablet" => __("Show On Desktop And Tablet", $shortname),
                "tablet_phone" => __("Show On Tablet And Phone", $shortname),
                "desktop_phone" => __("Show On Desktop And Phone", $shortname),
            ],
            "std" => "off",
            'usefor' => 'custom',
            'et_save_values' => true,
            "desc" => esc_html__("Choose on which devices to show the Back To Top Button. This feature first requires the main Back To Top Button to be enabled in Divi>Theme Options>General.",
                $shortname),
        ];
        $options[] = [
            "name" => "drh-8",
            "type" => "subcontent-end",
        ];
        $options[] = [
            "name" => "drh-9",
            "type" => "subcontent-start",
        ];
        $options[] = [
            "name" => esc_html__('Remove Plugin Data When Uninstalled', $shortname),
            "id" => "pac_drh_remove_plugin_data",
            "type" => "checkbox2",
            "std" => "off",
            "desc" => esc_html__("This setting will remove all plugin data and saved settings when you uninstall the plugin. Please use this setting carefully with the understanding that if you enable the setting you will lose all saved settings if you uninstall the plugin.",
                $shortname),
        ];
        $options[] = [
            "name" => "drh-9",
            "type" => "subcontent-end",
        ];
        $options[] = [
            "name" => "wrap-drh",
            "type" => "contenttab-wrapend",
        ];

        return $options;
    }

    add_filter('et_epanel_layout_data', 'pac_drh_epanel_fields');
}
/**
 * Include DRH Settings Portability
 *
 * @param $data
 *
 * @return mixed
 */
if (!function_exists('pac_drh_et_core_portability')) {
    function pac_drh_et_core_portability($data)
    {
        $drh_settings = [];
        $options = get_option('et_divi');
        if (!empty($options)) {
            foreach ($options as $key => $value) {
                if (strpos($key, 'pac_drh_') !== false) {
                    $drh_settings[$key] = 'true';
                }
            }
        }
        if (!empty($drh_settings)) {
            $data->include = wp_parse_args($drh_settings, $data->include);
        }

        return $data;
    }
}
/**
 * Add Filter Only When Import\Export ePanel Settings
 *
 * @since 2.2
 */
if (isset($_POST['context']) && isset($_POST['action']) && 'epanel' === sanitize_text_field($_POST['context']) && ('et_core_portability_export' === sanitize_text_field($_POST['action']) || 'et_core_portability_import' === sanitize_text_field($_POST['action']))) { // phpcs:ignore WordPress.Security.NonceVerification
    add_filter('et_core_portability_args_epanel', 'pac_drh_et_core_portability');
}