<?php
/**
 * Disabled Animation On Mobile Devices
 */
if (!function_exists('pac_drh_disabled_animation_css')) {
    function pac_drh_disabled_animation_css()
    {
        echo PHP_EOL;
        echo "<style id='pac-drh-animation-inline-css'>";
        echo "@media (min-width:300px) and (max-width:767px){.et_builder_inner_content .et_animated{opacity:1!important}.et_builder_inner_content *{-webkit-animation:none!important;-moz-animation:none!important;-o-animation:none!important;animation:none!important}}";
        echo "</style>";
        echo PHP_EOL;
    }
}
if (!function_exists('pac_drh_disabled_animation_js')) {
    function pac_drh_disabled_animation_js()
    {
        ?>
        <script type="text/javascript">
            var et_animation_data = '';
        </script>
        <?php
    }
}
if (pac_drh_enable_remove_animation()) {
    $detect_mobile = pac_drh_detect_mobile();
    if ($detect_mobile->isMobile() && !$detect_mobile->isTablet()) {
        add_action('wp_footer', 'pac_drh_disabled_animation_js', 10);
    }
    add_action('wp_head', 'pac_drh_disabled_animation_css');
}
/**
 * Back To Top Button Visibility
 */
if (!function_exists('pac_drh_backtotop_visibility_css')) {
    function pac_drh_backtotop_visibility_css()
    {
        $back_top_visibility = pac_drh_back_top_visibility();
        echo PHP_EOL;
        echo "<style id='pac-drh-btp-inline-css'>";
        $visibility_on_desktop = "@media (min-width: 980px) {.et_pb_scroll_top {display: none !important;}}";
        $visibility_on_tablet = "@media (min-width: 768px) and (max-width: 980px){.et_pb_scroll_top {display: none !important;}}";
        $visibility_on_phone = "@media (max-width: 767px) and (min-width: 0px) {.et_pb_scroll_top {display: none !important;}}";
        if ('desktop' === $back_top_visibility) {
            echo esc_html($visibility_on_tablet);
            echo esc_html($visibility_on_phone);
        } elseif ('tablet' === $back_top_visibility) {
            echo esc_html($visibility_on_desktop);
            echo esc_html($visibility_on_phone);
        } elseif ('phone' === $back_top_visibility) {
            echo esc_html($visibility_on_desktop);
            echo esc_html($visibility_on_tablet);
        } elseif ('desktop_tablet' === $back_top_visibility) {
            echo esc_html($visibility_on_phone);
        } elseif ('tablet_phone' === $back_top_visibility) {
            echo esc_html($visibility_on_desktop);
        } elseif ('desktop_phone' === $back_top_visibility) {
            echo esc_html($visibility_on_tablet);
        }
        echo "</style>";
        echo PHP_EOL;
    }

    if ('off' !== pac_drh_back_top_visibility()) {
        add_action('wp_head', 'pac_drh_backtotop_visibility_css');
    }
}
/**
 * Prevent Horizontal Scroll
 */
if (!function_exists('pac_drh_prevent_horizontal_scroll_css')) {
    function pac_drh_prevent_horizontal_scroll_css()
    {
        echo PHP_EOL;
        echo "<style id='pac-drh-phs-inline-css'>";
        echo "#page-container{overflow-x: hidden;}";
        echo "</style>";
        echo PHP_EOL;
    }

    if (pac_drh_enable_prevent_horizontal_scroll()) {
        add_action('wp_head', 'pac_drh_prevent_horizontal_scroll_css');
    }
}
/**
 * Mobile Custom Logo
 */
if (!function_exists('pac_drh_add_mobile_logo')) {
    function pac_drh_add_mobile_logo()
    {

        echo PHP_EOL;
        echo "<style id='pac-drh-add-mobile-logo-inline-css'>";
        echo "#logo {display: none;} @media (min-width:300px) and (max-width:767px){.pac_drh_desktop_logo{display:none!important}.pac_drh_mobile_logo{display:inline-block!important}}@media (min-width:768px) and (max-width:980px){.pac_drh_desktop_logo{display:none!important}.pac_drh_mobile_logo{display:inline-block!important}}@media (min-width:981px){.pac_drh_desktop_logo{display:inline-block!important}.pac_drh_mobile_logo{display:none!important}}";
        echo "</style>";
        echo PHP_EOL;
        ?>
        <script type="text/javascript" id="pac-drh-mobile-logo-inline-js">
            jQuery(document).ready(function () {
                let logoEle = jQuery('#logo');
                logoEle.css('display', 'block');
                if (logoEle.length > 0) {
                    logoEle.addClass('pac_drh_desktop_logo');
                    if (jQuery('.pac_drh_desktop_logo').length > 0) {
                        jQuery('.logo_container a').append('<img src="<?php esc_attr_e(pac_drh_mobile_logo()); ?>" alt="<?php esc_attr_e(get_bloginfo('name')); ?>" id="logo" class="pac_drh_mobile_logo" data-height-percentage="<?php esc_attr_e(et_get_option('logo_height',
                            '54'));?>" />');
                    }
                }
            });
        </script>
        <?php
        echo PHP_EOL;
    }

    if (pac_drh_mobile_logo()) {
        add_action('wp_footer', 'pac_drh_add_mobile_logo');
    }
}
/**
 * Mobile Header Bar Color
 */
if (!function_exists('pac_drh_change_mobile_header_color')) {
    function pac_drh_change_mobile_header_color()
    {
        echo PHP_EOL;
        echo sprintf('<meta name="theme-color" content="%s" />', esc_attr(pac_drh_mobile_header_color()));
        echo PHP_EOL;
    }

    if ('' !== pac_drh_mobile_header_color()) {
        add_action('wp_head', 'pac_drh_change_mobile_header_color');
    }
}
/**
 * Mobile Pinch Zooming
 */
if (!function_exists('pac_drh_mobile_pinch_zoom')) {
    function pac_drh_mobile_pinch_zoom()
    {
        echo PHP_EOL;
        echo '<meta name="viewport" content="width=device-width, user-scalable=yes, initial-scale=1.0, minimum-scale=0.1, maximum-scale=10.0">';
        echo PHP_EOL;
    }

    if (pac_drh_enable_mobile_pinch_zoom()) {
        remove_action('wp_head', 'et_add_viewport_meta');
        add_action('wp_head', 'pac_drh_mobile_pinch_zoom');
    }
}
/**
 * Disable Hover Effects On Touch Devices
 */
if (!function_exists('pac_drh_disabled_hover_effects')) {
    function pac_drh_disabled_hover_effects()
    {
        // PHP Check Is Mobile/Tablet
        if (!wp_is_mobile()) {
            return;
        }
        if (pac_drh_disabled_hover_effects()) { ?>
            <script type="text/javascript" id="pac-drh-disabled-hover-effects-inline-js">
                $(document).ready(function () {
                    setTimeout(function () {
                        // JS Check Is Mobile/Tablet
                        let isPhoneTablet = window.matchMedia('only screen and (max-width: 980px)').matches;
                        if (!isPhoneTablet && isPhoneTablet !== undefined) {
                            return;
                        }
                        // IF Element Have Class
                        let etPBModule = $('.et_pb_module');
                        if (etPBModule.length > 0) {
                            etPBModule.each(function () {
                                if ($(this).hasClass('et_multi_view__hover_selector')) {
                                    $(this).removeClass('et_multi_view__hover_selector');
                                }
                            });
                        }
                        // IF Element Have Hover
                        let sheetCount = document.styleSheets.length;
                        let lastSheet = document.styleSheets[sheetCount - 1];
                        let ruleCount;
                        if (lastSheet.cssRules) {
                            ruleCount = lastSheet.cssRules.length;
                        } else if (lastSheet.rules) {
                            ruleCount = lastSheet.rules.length;
                        }
                        if (ruleCount > 0 && ruleCount !== undefined) {
                            let i;
                            for (i = 0; i < ruleCount; i++) {
                                let inlineStyleSheet = lastSheet.cssRules[i];
                                let cssText = inlineStyleSheet.cssText;
                                if (cssText.indexOf(':hover') >= 0) {
                                    inlineStyleSheet.selectorText = inlineStyleSheet.selectorText.replace(':hover', '.pac_drh_responsive_hover_effect:hover');
                                }
                            }
                        }
                    }, 500);
                });
            </script>
            <?php
        }
    }

    add_action('wp_footer', 'pac_drh_disabled_hover_effects');
}
/**
 * Show Hide Presets / Custom Preset Value
 */
if (!function_exists('pac_drh_presets_settings')) {
    function pac_drh_presets_settings()
    {
        if (!pac_drh_enable_presets()) {
            echo PHP_EOL;
            echo "<style id='pac-drh-presets-inline-css'>";
            echo ".pac_preset{display: none !important;}";
            echo "</style>";
            echo PHP_EOL;
        }
        if (!pac_drh_enable_custom_preview()) {
            echo PHP_EOL;
            echo "<style id='pac-drh-custom-presets-inline-css'>";
            echo ".pac_set_preview_size_input_filed{display: none !important;}";
            echo "</style>";
            echo PHP_EOL;
        }
    }

    add_action('wp_footer', 'pac_drh_presets_settings');
    add_action('admin_footer', 'pac_drh_menu_hamburger_with_text');
}
/**
 * Disable Divi Responsive Views Settings
 */
if (!function_exists('pac_drh_hide_divi_responsive_views')) {
    function pac_drh_hide_divi_responsive_views()
    {
        $app_frame_css = '{position: absolute !important;top: 0 !important;padding-top: 0 !important}';
        if (et_fb_is_enabled() && !et_builder_bfb_enabled()) {
            $app_frame_css = '{padding-top: 0 !important;}';
        }
        echo PHP_EOL;
        echo "<style id='pac-drh-hide-divi-responsive-views-inline-css'>";
        echo ".et-bfb-responsive-view-controls, .et-fb-responsive-view-controls {display: none;}";
        echo ".et-db #et-boc .et-l #et-fb-app-frame ".esc_html($app_frame_css);
        echo ".wp-admin .et-boc.et-fb-root-ancestor.et-fb-iframe-ancestor{margin-top: 20px !important;}";
        echo "</style>";
        echo PHP_EOL;
    }

    if (pac_drh_enable_hide_responsive_view()) {
        add_action('admin_footer', 'pac_drh_hide_divi_responsive_views');
        add_action('wp_footer', 'pac_drh_hide_divi_responsive_views');
    }
}
