<?php
add_action('admin_print_styles', function () {
    echo "<style id='pac-drh-codemirror-inline-css'>";
    echo "#wrap-drh .CodeMirror-linenumber {left: -40px !important;}";
    echo "#wrap-drh .CodeMirror-lines { margin-left: 40px !important;}";
    echo "</style>";
});
/**
 * Media Query CSS Render
 */
if (!function_exists('pac_drh_media_queries_css')) {
    function pac_drh_media_queries_css()
    {
        $desktop_media_query = et_get_option('pac_drh_desktop_media_query');
        $tablet_media_query = et_get_option('pac_drh_tablet_media_query');
        $phone_media_query = et_get_option('pac_drh_phone_media_query');
        $desktop_tablet_media_query = et_get_option('pac_drh_desktop_tablet_media_query');
        $tablet_phone_media_query = et_get_option('pac_drh_tablet_phone_media_query');
        if (!empty($desktop_media_query) || !empty($tablet_media_query) || !empty($phone_media_query) || !empty($desktop_tablet_media_query) || !empty($tablet_phone_media_query)) {
            echo PHP_EOL;
            echo "<style id='pac-drh-media-queries-inline-css'>";
            // Desktop
            if (!empty($desktop_media_query)) {
                echo "@media (min-width:981px){ ";
                echo esc_html($desktop_media_query);
                echo "}";
            }
            // Tablet
            if (!empty($tablet_media_query)) {
                echo "@media (min-width:768px) and (max-width:980px){";
                echo esc_html($tablet_media_query);
                echo "}";
            }
            // Phone
            if (!empty($phone_media_query)) {
                echo "@media (min-width:300px) and (max-width:767px){";
                echo esc_html($phone_media_query);
                echo "}";
            }
            // Desktop & Tablet
            if (!empty($desktop_tablet_media_query)) {
                echo "@media only screen and (min-width: 767px) {";
                echo esc_html($desktop_tablet_media_query);
                echo "}";
            }
            // Tablet & Phone
            if (!empty($tablet_phone_media_query)) {
                echo "@media only screen and (max-width: 980px) {";
                echo esc_html($tablet_phone_media_query);
                echo "}";
            }
            echo "</style>";
            echo PHP_EOL;
        }
    }

    add_action('wp_print_styles', 'pac_drh_media_queries_css');
}
/**
 * Custom Media Query CSS
 */
if (!function_exists('pac_drh_custom_media_queries_css')) {
    function pac_drh_custom_media_queries_css()
    {
        $cmq_style = '';
        foreach (pac_drh_custom_media_queries() as $cmq) {
            $cmq_min = et_get_option("pac_drh_cmq_min_$cmq");
            $cmq_max = et_get_option("pac_drh_cmq_max_$cmq");
            $cmq_css = et_get_option("pac_drh_cmq_css_$cmq");
            if (!empty($cmq_min) && !empty($cmq_max) && !empty($cmq_css)) {
                $cmq_style .= "@media only screen and (max-width: ".esc_html($cmq_max).") and (min-width: ".esc_html($cmq_min).") {".esc_html($cmq_css)."}";
            }
        }
        if (!empty($cmq_style)) {
            echo PHP_EOL;
            echo "<style id='pac-drh-custom-media-queries-inline-css'>";
            echo $cmq_style; // phpcs:ignore
            echo "</style>";
            echo PHP_EOL;
        }
    }

    add_action('wp_print_styles', 'pac_drh_custom_media_queries_css');
}
