<?php
//======================================================================
//  Add Word Before Hamburger Icon
//======================================================================
if (!function_exists('pac_drh_menu_hamburger_with_text')) {
    function pac_drh_menu_hamburger_with_text()
    {
        $hamburger_text = pac_drh_hamburger_header_menu_text();
        if (!empty($hamburger_text)) {
            echo PHP_EOL;
            echo "<style id='pac-drh-menu-hamburger-text-inline-css'>";
            echo "#et-top-navigation #et_mobile_nav_menu:before{content:'".esc_attr($hamburger_text)."';position: absolute !important;right: 30px;}";
            echo "@media (max-width: 980px) {#et-top-navigation #et_mobile_nav_menu:before{top: 28px;right: 30px;} #et-top-navigation #et_top_search {margin: 0 45px 0 0;}}";
            if (pac_drh_enable_hamburger_menu_desktop()) {
                $top = !pac_drh_enable_collapse_mobile_submenus() ? '28px' : '20px';
                echo "@media (min-width: 980px) {#et-top-navigation #et_mobile_nav_menu:before{right: 40px;top:".esc_attr($top)." ;}}";
            }
            $breakpoint = pac_drh_menu_breakpoint();
            if (!!empty($breakpoint) && intval($breakpoint) > 981 && !preg_match('/^[1-9][0-9]{0,15}$/', $breakpoint)) {
                echo "@media only screen and (max-width:".esc_attr($breakpoint)."){#et_top_search {margin: 14px 40px 0 0 !important;}}";
            }
            echo "@media only screen and (max-width:980px){#et_top_search {margin: 0 40px 0 0 !important;}}";
            echo "</style>";
            echo PHP_EOL;
        }
    }

    if (pac_drh_enable_hamburger_menu_text()) {
        add_action('wp_head', 'pac_drh_menu_hamburger_with_text');
    }
}
//======================================================================
// Add Hamburger Desktop
//======================================================================
if (!function_exists('pac_drh_header_hamburger_menu')) {
    function pac_drh_header_hamburger_menu()
    {
        echo PHP_EOL;
        echo "<style id='pac-drh-header-hamburger-menu-inline-css'>";
        echo "@media (min-width:980px){#top-menu{display:none}#et_mobile_nav_menu{display:flex;float:none;margin:-6px 6px;;align-items:center}}";
        echo "@media (min-width: 980px) {#et-top-navigation .et-cart-info {margin-top: -10px;}#et_top_search {float: left;margin: -5px 50px 0 10px;}}";
        echo "</style>";
        echo PHP_EOL;
    }

    if (pac_drh_enable_hamburger_menu_desktop()) {
        add_action('wp_head', 'pac_drh_header_hamburger_menu');
    }
}
//======================================================================
// Opened Mobile Menu Icon
//======================================================================
if (!function_exists('pac_drh_opened_menu_icon')) {
    function pac_drh_opened_menu_icon()
    {
        echo PHP_EOL;
        echo "<style id='pac-drh-opened-menu-icon-inline-css'>";
        echo "#et_mobile_nav_menu .mobile_nav.opened .mobile_menu_bar:before{content:'".esc_attr(et_pb_process_font_icon('M'))."';";
        echo "</style>";
        echo PHP_EOL;
    }

    if (pac_drh_enable_open_mobile_icon()) {
        add_action('wp_head', 'pac_drh_opened_menu_icon');
    }
}
//======================================================================
//  Fixed Navigation Bar Fixed
//======================================================================
if (!function_exists('pac_drh_make_navigation_bar_fixed')) {
    function pac_drh_make_navigation_bar_fixed()
    {
        echo PHP_EOL;
        echo "<style id='pac-drh-make-navigation-bar-fixed-inline-css'>";
        echo "@media (max-width: 767px) and (min-width: 0px){.et_fixed_nav #main-header {position: fixed;}}";
        echo "@media (min-width: 768px) and (max-width: 980px){.et_fixed_nav #main-header {position: fixed;}}";
        echo "@media (max-width: 981px) { #main-header { position: fixed;}}";
        echo "</style>";
        echo PHP_EOL;
    }

    if (pac_drh_fixed_navigation_bar()) {
        add_action('wp_head', 'pac_drh_make_navigation_bar_fixed');
    }
}
//======================================================================
//  Mobile Menu Breakpoint
//======================================================================
if (!function_exists('pac_drh_change_phone_menu_breakpoint')) {
    function pac_drh_change_phone_menu_breakpoint()
    {
        $breakpoint = pac_drh_menu_breakpoint();
        if (preg_match('/^[1-9][0-9]{0,15}$/', $breakpoint)) {
            return;
        }
        echo PHP_EOL;
        echo "<style id='pac-drh-change-phone-menu-breakpoint-inline-css'>";
        if (intval($breakpoint) > 981) {
            echo "@media only screen and (max-width:".esc_attr($breakpoint)."){#et_mobile_nav_menu {display: block !important;margin-bottom: 10px;margin-top: 5px}#top-menu-nav{display: none !important}#et_top_search {margin: 14px 15px 0 0;float: left;}#et-top-navigation .et-cart-info {margin: 8px 0 0 22px;}}";
        }
        if (intval($breakpoint) < 980) {
            echo "@media only screen and (min-width:".esc_attr($breakpoint)."){#top-menu{display:block!important}#et_mobile_nav_menu{display:none!important}}";
        }
        echo "@media (max-width: 767px) and (min-width: 0px){ #et_top_search{margin: 5px 15px 0 0;float: left;}}";
        echo "</style>";
        echo PHP_EOL;
    }

    if (!empty(pac_drh_menu_breakpoint())) {
        add_action('wp_head', 'pac_drh_change_phone_menu_breakpoint');
    }
}
//======================================================================
// Collapse Mobile Menu Submenus
//======================================================================
if (!function_exists('pac_drh_collapse_mobile_submenus')) {
    function pac_drh_collapse_mobile_submenus()
    {
        echo PHP_EOL;
        $accent_color = pac_drh_get_color_scheme();
        echo "<style id='pac-drh-collapse-mobile-submenus-inline-css'>";
        echo "#et_mobile_nav_menu .et-db #et-boc .et-l ul.et_mobile_menu li.menu-item-has-children .mobile-toggle,#et_mobile_nav_menu .et-db #et-boc .et-l ul.et_mobile_menu li.page_item_has_children .mobile-toggle,#et_mobile_nav_menu ul.et_mobile_menu li.menu-item-has-children .mobile-toggle,#et_mobile_nav_menu ul.et_mobile_menu li.page_item_has_children .mobile-toggle{width:44px;height:100%;padding:0!important;max-height:44px;border:none;position:absolute;right:0;top:0;z-index:999;background-color:transparent}#et_mobile_nav_menu .et-db #et-boc .et-l ul.et_mobile_menu>li.menu-item-has-children,#et_mobile_nav_menu .et-db #et-boc .et-l ul.et_mobile_menu>li.menu-item-has-children .sub-menu li.menu-item-has-children,#et_mobile_nav_menu .et-db #et-boc .et-l ul.et_mobile_menu>li.page_item_has_children,#et_mobile_nav_menu ul.et_mobile_menu>li.menu-item-has-children,#et_mobile_nav_menu ul.et_mobile_menu>li.menu-item-has-children .sub-menu li.menu-item-has-children,#et_mobile_nav_menu ul.et_mobile_menu>li.page_item_has_children{position:relative}#et_mobile_nav_menu .et-db #et-boc .et-l .et_mobile_menu .menu-item-has-children>a,#et_mobile_nav_menu .et_mobile_menu .menu-item-has-children>a{background-color:transparent}#et_mobile_nav_menu #main-header ul.et_mobile_menu .menu-item-has-children .sub-menu,#et_mobile_nav_menu .et-db #et-boc .et-l ul.et_mobile_menu .menu-item-has-children .sub-menu,#et_mobile_nav_menu .et-db #main-header ul.et_mobile_menu .menu-item-has-children .sub-menu,#et_mobile_nav_menu ul.et_mobile_menu .menu-item-has-children .sub-menu{display:none!important;visibility:hidden!important}#main-header ul.et_mobile_menu .menu-item-has-children .sub-menu.visible,.et-db #et-boc .et-l ul.et_mobile_menu .menu-item-has-children .sub-menu.visible,.et-db #main-header ul.et_mobile_menu .menu-item-has-children .sub-menu.visible,ul.et_mobile_menu .menu-item-has-children .sub-menu.visible{display:block!important;visibility:visible!important}#et_mobile_nav_menu .et-db #et-boc .et-l ul.et_mobile_menu li.menu-item-has-children .mobile-toggle,#et_mobile_nav_menu ul.et_mobile_menu li.menu-item-has-children .mobile-toggle{text-align:center;opacity:1}#et_mobile_nav_menu .et-db #et-boc .et-l ul.et_mobile_menu li.menu-item-has-children .mobile-toggle::after,#et_mobile_nav_menu ul.et_mobile_menu li.menu-item-has-children .mobile-toggle::after{top:10px;position:relative;font-family:ETModules,serif;content:'3';color:".esc_attr($accent_color).";background:#f0f3f6;border-radius:50%;padding:3px}#et_mobile_nav_menu .et-db #et-boc .et-l ul.et_mobile_menu li.menu-item-has-children.dt-open>.mobile-toggle::after,#et_mobile_nav_menu ul.et_mobile_menu li.menu-item-has-children.dt-open>.mobile-toggle::after{content:'2'}#et_mobile_nav_menu .et_pb_menu_0.et_pb_menu .et_mobile_menu:after{position:absolute;right:5%;margin-left:-20px;top:-14px;width:0;height:0;content:'';border-left:20px solid transparent;border-right:20px solid transparent;border-bottom:20px solid #fff}#et_mobile_nav_menu .mobile_menu_bar{position:relative;display:block;bottom:10px;line-height:0}#et_mobile_nav_menu .et_pb_menu_0.et_pb_menu .et_mobile_menu,#et_mobile_nav_menu .et_pb_menu_0.et_pb_menu .et_mobile_menu ul{background-color:#fff!important;border-radius:10px}";
        echo "</style>";
        echo PHP_EOL;
        ?>
        <script type="text/javascript" id="pac-drh-collapse-mobile-submenus-inline-js">
            jQuery(function ($) {
                $(document).ready(function () {
                    let isCollapseSubMenus = '<?php echo esc_js(pac_drh_enable_collapse_other_submenus());?>';
                    $("body #et_mobile_nav_menu ul.et_mobile_menu li.menu-item-has-children, body #et_mobile_nav_menu ul.et_mobile_menu  li.page_item_has_children").append('<a href="javascript:void(0)" class="mobile-toggle"></a>');
                    $('#et_mobile_nav_menu ul.et_mobile_menu li.menu-item-has-children .mobile-toggle, #et_mobile_nav_menu ul.et_mobile_menu li.page_item_has_children .mobile-toggle').click(function (event) {
                        event.preventDefault();
                        let parentLIObj = $(this).parent('li');
                        if (parentLIObj.hasClass('dt-open')) {
                            parentLIObj.toggleClass('dt-open');
                            parentLIObj.find('ul.children').first().toggleClass('visible');
                            parentLIObj.find('ul.sub-menu').first().toggleClass('visible');
                        } else {
                            if (!parentLIObj.parent('ul').hasClass('visible') && isCollapseSubMenus) {
                                $('li.menu-item-has-children').removeClass('dt-open');
                                $('li.menu-item-has-children .sub-menu').removeClass('visible');
                            }
                            parentLIObj.toggleClass('dt-open');
                            parentLIObj.find('ul.children').first().toggleClass('visible');
                            parentLIObj.find('ul.sub-menu').first().toggleClass('visible');
                        }
                    });
                    let iconFINAL = 'P';
                    $('body ul.et_mobile_menu li.menu-item-has-children, body ul.et_mobile_menu li.page_item_has_children').attr('data-icon', iconFINAL);
                    $('.mobile-toggle').on('mouseover', function () {
                        $(this).parent().addClass('is-hover');
                    }).on('mouseout', function () {
                        $(this).parent().removeClass('is-hover');
                    })
                });
            });
        </script>
        <?php
        if (pac_drh_openclose_submenu_with_parent()) { ?>
            <script type="text/javascript" id="pac-drh-openclose-submenu-parent-inline-js">
                jQuery(function ($) {
                    $(document).ready(function () {
                        $("#et_mobile_nav_menu .et_mobile_menu .menu-item-has-children a").each(function () {
                            $(this).click(function (e) {
                                let parent = $(this).siblings('ul').children('li').find('ul');
                                parent.removeClass('visible');
                                parent.toggleClass('visible');
                            })
                        });
                        $("body #et_mobile_nav_menu ul.et_mobile_menu li.menu-item-has-children, body #et_mobile_nav_menu ul.et_mobile_menu  li.page_item_has_children").each(function () {
                            var outerThis = this;
                            $(outerThis).find('a:first').attr('href', 'javascript:void(0)').off('click');
                            $(outerThis).find('a:first').click(function (e) {
                                $(outerThis).find('ul').toggleClass('visible')
                            });
                        });
                    });
                })
            </script>
            <?php
        }
    }

    if (pac_drh_enable_collapse_mobile_submenus()) {
        add_action('wp_head', 'pac_drh_collapse_mobile_submenus');
    }
}
