<?php
/**
 * Filter Fields
 *
 * @param $fields_unprocessed
 *
 * @return array
 */
if (!function_exists('pac_drh_add_staking_toggle')) {
    function pac_drh_add_staking_toggle($fields_unprocessed)
    {
        global $shortname;
        $custom_fields = [];
        $custom_fields['pac_drh_enable_stacking'] = [
            'label' => __('Enable Column Stacking Order', $shortname),
            'type' => 'select',
            'options' => [
                'off' => __('Default Column Stacking Order', $shortname),
                'pac_drh_stack_row pac_drh_stack_tab_mob' => __('Enable Column Stacking Order on both Tablet and Phone', $shortname),
                'pac_drh_stack_row pac_drh_stack_tab_only' => __('Enable Column Stacking Order on Tablet only', $shortname),
                'pac_drh_stack_row pac_drh_stack_mob_only' => __('Enable Column Stacking Order on Phone only', $shortname),
            ],
            'default' => 'off',
            'description' => __('Choose which Column Stacking Order option to use.', $shortname),
            'tab_slug' => 'custom_css',
            'toggle_slug' => 'classes',
        ];

        return wp_parse_args($custom_fields, $fields_unprocessed);
    }

    add_filter('et_pb_all_fields_unprocessed_et_pb_row', 'pac_drh_add_staking_toggle');
    add_filter('et_pb_all_fields_unprocessed_et_pb_row_inner', 'pac_drh_add_staking_toggle');
}
/**
 * Filter Fields
 *
 * @param $fields_unprocessed
 *
 * @return array
 */
if (!function_exists('pac_drh_filter_column_fields')) {
    function pac_drh_filter_column_fields($fields_unprocessed)
    {
        global $shortname;
        $custom_fields = [];
        $custom_fields['pac_drh_add_staking_order_tab'] = [
            'label' => __('Stacking Order on Tablet', $shortname),
            'type' => 'select',
            'options' => [
                'off' => __('Stacking Order on Tablet', $shortname),
                'pac_drh_order_tab_one' => __('One', $shortname),
                'pac_drh_order_tab_two' => __('Two', $shortname),
                'pac_drh_order_tab_three' => __('Three', $shortname),
                'pac_drh_order_tab_four' => __('Four', $shortname),
                'pac_drh_order_tab_five' => __('Five', $shortname),
                'pac_drh_order_tab_six' => __('Six', $shortname),
                'pac_drh_order_tab_seven' => __('Seven', $shortname),
                'pac_drh_order_tab_eight' => __('Eight', $shortname),
            ],
            'default' => 'off',
            'description' => __('Select a number to designate the order in which the columns will stack on Tablet.', $shortname),
            'tab_slug' => 'custom_css',
            'toggle_slug' => 'classes',
        ];
        $custom_fields['pac_drh_add_staking_order_mob'] = [
            'label' => __('Stacking Order on Phone', $shortname),
            'type' => 'select',
            'options' => [
                'off' => __('Stacking Order on Phone', $shortname),
                'pac_drh_order_mob_one' => __('One', $shortname),
                'pac_drh_order_mob_two' => __('Two', $shortname),
                'pac_drh_order_mob_three' => __('Three', $shortname),
                'pac_drh_order_mob_four' => __('Four', $shortname),
                'pac_drh_order_mob_five' => __('Five', $shortname),
                'pac_drh_order_mob_six' => __('Six', $shortname),
                'pac_drh_order_mob_seven' => __('Seven', $shortname),
                'pac_drh_order_mob_eight' => __('Eight', $shortname),
            ],
            'default' => 'off',
            'description' => __('Select a number to designate the order in which the columns will stack on Phone.', $shortname),
            'tab_slug' => 'custom_css',
            'toggle_slug' => 'classes',
        ];

        return wp_parse_args($custom_fields, $fields_unprocessed);
    }

    add_filter('et_pb_all_fields_unprocessed_et_pb_column', 'pac_drh_filter_column_fields');
}
