<?php
/**
 * Filter Fields
 *
 * @param $fields_unprocessed
 *
 * @return array
 */
if (!function_exists('pac_drh_add_col_numbering_options')) {
    function pac_drh_add_col_numbering_options($fields_unprocessed)
    {
        global $shortname;
        $custom_fields = [];
        $custom_fields['pac_drh_column_numbers_tablet'] = [
            'label' => __('Number of Columns on Tablet', $shortname),
            'type' => 'select',
            'options' => [
                'off' => __('Default', $shortname),
                'pac_drh_tab_col_one' => __('One', $shortname),
                'pac_drh_tab_col_two' => __('Two', $shortname),
                'pac_drh_tab_col_three' => __('Three', $shortname),
                'pac_drh_tab_col_four' => __('Four', $shortname),
                'pac_drh_tab_col_five' => __('Five', $shortname),
                'pac_drh_tab_col_six' => __('Six', $shortname),
            ],
            'default' => 'off',
            'description' => __('Select Number of Columns on Tablet', $shortname),
            'tab_slug' => 'custom_css',
            'toggle_slug' => 'classes',
        ];
        $custom_fields['pac_drh_column_numbers_phone'] = [
            'label' => __('Number of Columns on Phone', $shortname),
            'type' => 'select',
            'options' => [
                'off' => __('Default', $shortname),
                'pac_drh_phone_col_one' => __('One', $shortname),
                'pac_drh_phone_col_two' => __('Two', $shortname),
                'pac_drh_phone_col_three' => __('Three', $shortname),
                'pac_drh_phone_col_four' => __('Four', $shortname),
                'pac_drh_phone_col_five' => __('Five', $shortname),
                'pac_drh_phone_col_six' => __('Six', $shortname),
            ],
            'default' => 'off',
            'description' => __('Select Number of Columns on Phone', $shortname),
            'tab_slug' => 'custom_css',
            'toggle_slug' => 'classes',
        ];

        return wp_parse_args($custom_fields, $fields_unprocessed);
    }

    add_filter('et_pb_all_fields_unprocessed_et_pb_row', 'pac_drh_add_col_numbering_options');
    add_filter('et_pb_all_fields_unprocessed_et_pb_row_inner', 'pac_drh_add_col_numbering_options');
}

