<?php
/**
 * Check Dependency
 *
 * @return bool|void
 */
if (!function_exists('pac_drh_check_is_divi_theme')) {
    function pac_drh_check_is_divi_theme()
    {
        $active_theme = wp_get_theme()->get('Name');
        $parent_theme = wp_get_theme()->get('Template');
        // $divi_builder = is_plugin_active('divi-builder/divi-builder.php');
        $divi_ghoster = is_plugin_active('divi-ghoster/divi-ghoster.php');
        if ('divi' == strtolower($active_theme) || 'divi' == strtolower($parent_theme) || 'extra' == strtolower($active_theme) || 'extra' == strtolower($parent_theme) || $divi_ghoster) {
            return true;
        }
        deactivate_plugins(PAC_DRH_FILE);
        wp_die('<p>'.sprintf(esc_attr__('The Divi Responsive Helper plugin only works with Divi Theme and Extra Theme only. Your current active theme is %2$s %1$s %3$s. The plugin will be deactivated and you may return to your WordPress dashboard.',
                'Divi'), esc_html($active_theme), '<b>', '</b>').'</p> <a href="'.esc_url(admin_url('index.php')).'">'.esc_attr__('Go Back', 'Divi').'</a>');
    }

    add_action('init', 'pac_drh_check_is_divi_theme');
    register_activation_hook(PAC_DRH_FILE, 'pac_drh_check_is_divi_theme');
}