<?php
/*
Plugin Name: Divi Responsive Helper
Plugin URI:  https://www.peeayecreative.com/product/divi-responsive-helper
Description: Quickly make Divi responsive and easily adjust design settings on all devices in the Divi Builder!
Version:     2.3
Author:      Pee-Aye Creative
Author URI:  https://www.peeayecreative.com/
Update URI:  https://elegantthemes.com/
License:     GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html

Divi Responsive Helper is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or
any later version.

Divi Responsive Helper is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Divi Responsive Helper. If not, see https://www.gnu.org/licenses/gpl-2.0.html.

-----------------------------------------------------------
*/
defined('ABSPATH') or die('HEY, WHAT ARE YOU DOING HERE? YOU SILLY HUMAN!');
if (!defined('PAC_DRH_FILE')) {
    define('PAC_DRH_FILE', __FILE__);
}
if (!defined('PAC_DRH_VERSION')) {
    define('PAC_DRH_VERSION', '2.3');
}
if (!defined('PAC_DRH_PATH')) {
    define('PAC_DRH_PATH', __DIR__);
    //define('PAC_DRH_PATH', untrailingslashit(plugin_dir_path(PAC_DRH_FILE)));
}
if (!defined('PAC_DRH_URL')) {
    define('PAC_DRH_URL', untrailingslashit(plugin_dir_url(PAC_DRH_FILE)));
}
if (!function_exists('get_plugins')) {
    require_once ABSPATH.'wp-admin/includes/plugin.php';
}
/**
 * General Helpers
 *
 * {@see pac_drh_get_option()} function.
 * {@see pac_drh_detect_mobile()} function.
 * {@see pac_drh_minify()} function.
 * {@see pac_drh_custom_media_queries()} function.
 * {@see pac_drh_get_color_scheme()} function.
 * {@see pac_drh_get_pages_list()} function.
 * {@see pac_drh_is_post_page()} function.
 * {@see pac_drh_log()} function.
 * {@see pac_drh_dd()} function.
 */
require_once(PAC_DRH_PATH.'/includes/helpers/general-helpers.php');
/**
 *  Settings Help Functions
 * {@see pac_drh_enable_menu_module_settings()} function.
 * {@see pac_drh_enable_hamburger_menu_text()} function.
 * {@see pac_drh_hamburger_header_menu_text()} function.
 * {@see pac_drh_enable_hamburger_menu_desktop()} function.
 * {@see pac_drh_enable_collapse_mobile_submenus()} function.
 * {@see pac_drh_enable_collapse_other_submenus()} function.
 * {@see pac_drh_openclose_submenu_with_parent()} function.
 * {@see pac_drh_enable_custom_gutter_width()} function.
 * {@see pac_drh_fixed_navigation_bar()} function.
 * {@see pac_drh_enable_open_mobile_icon()} function.
 * {@see pac_drh_menu_breakpoint()} function.
 * {@see pac_drh_enable_prevent_horizontal_scroll()} function.
 * {@see pac_drh_enable_remove_animation()} function.
 * {@see pac_drh_back_top_visibility()} function.
 * {@see pac_drh_mobile_logo()} function.
 * {@see pac_drh_mobile_header_color()} function.
 * {@see pac_drh_enable_mobile_pinch_zoom()} function.
 * {@see pac_drh_disabled_hover_effects()} function.
 * {@see pac_drh_enable_hide_responsive_view()} function.
 * {@see pac_drh_enable_view_port_size()} function.
 * {@see pac_drh_enable_presets()} function.
 * {@see pac_drh_enable_custom_preview()} function.
 * {@see pac_drh_enable_widow_fixer()} function.
 * {@see pac_drh_enable_col_stacking()} function.
 * {@see pac_drh_enable_number_of_columns()} function.
 * {@see pac_drh_enable_blog_number_of_columns()} function.
 * {@see pac_drh_enable_portfolio_number_of_columns()} function.
 * {@see pac_drh_enable_gallery_number_of_columns()} function.
 * {@see pac_drh_enable_shop_number_of_columns()} function.
 * {@see pac_drh_enable_related_products_number_of_columns()} function.
 * {@see pac_drh_enable_crosssells_number_of_columns()} function.
 * {@see pac_drh_enable_upsells_number_of_columns()} function.
 * {@see pac_drh_enable_mobile_parallax()} function.
 * {@see pac_drh_enable_blurb_settings()} function.
 * {@see pac_drh_enable_tabs_layout_settings()} function.
 * {@see pac_drh_enable_text_sizes()} function.
 * {@see pac_drh_enable_show_hide_menu_item()} function.
 * {@see pac_drh_enable_responsive_blog_count()} function.
 * {@see pac_drh_enable_responsive_shop_count()} function.
 * {@see pac_drh_enable_responsive_gallery_count()} function.
 * {@see pac_drh_enable_responsive_portfolio_count()} function.
 * {@see pac_drh_enable_auto_responsive()} function.
 * {@see pac_drh_custom_presets()} function.
 */
require_once(PAC_DRH_PATH.'/includes/helpers/setting-helpers.php');
/**
 * Check Dependency
 *
 * {@see pac_drh_check_is_divi_theme} function.
 */
require_once PAC_DRH_PATH.'/includes/admin/base/dependency-check.php';
/**
 * Add Custom Media Query
 *
 * @param $media_queries
 *
 * @return mixed
 */
if (!function_exists('pac_drh_maybe_custom_media_queries')) {
    function pac_drh_maybe_custom_media_queries($media_queries)
    {
        // Tablet
        $media_queries['pac_drh_min_768_max_980'] = '@media only screen and (min-width: 768px) and (max-width: 980px)';
        // Phone
        $media_queries['pac_drh_max_767'] = '@media only screen and (max-width: 767px)';
        // Tablet & Phone
        $media_queries['pac_drh_max_980'] = '@media only screen and (max-width: 980px)';

        return $media_queries;
    }

    add_filter('et_builder_media_queries', 'pac_drh_maybe_custom_media_queries');
}
/**
 * Row And Action Links
 *
 * @param $actions
 *
 * @return mixed
 */
if (!function_exists('pac_drh_plugin_action_links')) {
    function pac_drh_plugin_action_links($actions)
    {
        $custom_actions = sprintf('<a href="%s">'.__('Settings', 'divi').' </a>.', esc_url(admin_url('admin.php?page=et_divi_options#wrap-drh')));
        array_unshift($actions, $custom_actions);

        return $actions;
    }

    add_filter('plugin_action_links_'.plugin_basename(PAC_DRH_FILE), 'pac_drh_plugin_action_links', 10);
}
/**
 * Public Scripts
 */
if (!function_exists('pac_drh_if_user_logged_in')) {
    function pac_drh_if_user_logged_in()
    {
        function pac_drh_enqueue_scripts()
        {
            $min = pac_drh_minify();
            wp_enqueue_style('pac_drh_public', plugins_url('/includes/assets/public/css/style.css', PAC_DRH_FILE), false, PAC_DRH_VERSION);
            if (is_user_logged_in() === true) {
                if (pac_drh_enable_auto_responsive()) {
                    wp_enqueue_script('pac_drh_vb_responsive', plugins_url("/includes/assets/admin/js/responsive-tabs$min.js", PAC_DRH_FILE), [], PAC_DRH_VERSION, true);
                    wp_localize_script('pac_drh_vb_responsive', 'pac_drh_vb_obj', ['responsiveTabs' => 'on']);
                }
                if (pac_drh_enable_presets() || pac_drh_enable_custom_preview()) {
                    wp_enqueue_script('pac_drh_vb_responsive_buttons', plugins_url("/includes/assets/admin/js/presets$min.js", PAC_DRH_FILE), ['jquery'], PAC_DRH_VERSION, true);
                    wp_localize_script('pac_drh_vb_responsive_buttons', 'pac_drh_custom_presets', pac_drh_custom_presets());
                    wp_enqueue_style('pac_drh_responsive_settings_vb_css', plugins_url('/includes/assets/admin/css/style.css', PAC_DRH_FILE));
                }
            }
            if (pac_drh_enable_widow_fixer()) {
                wp_enqueue_script('pac_drh_dwf_widow', plugins_url("/includes/assets/public/js/dwf-widow$min.js", PAC_DRH_FILE), [], PAC_DRH_VERSION, true);
                wp_localize_script('pac_drh_dwf_widow', 'pacDRHWF', ['isExcludeEnabled' => et_get_option('pac_drh_exclude_widow_fixer')]);
            }
            if (pac_drh_enable_col_stacking()) {
                wp_enqueue_style('pac_drh_stacking', plugins_url("/includes/assets/public/css/stacking$min.css", PAC_DRH_FILE), [], PAC_DRH_VERSION);
            }
            if (pac_drh_enable_number_of_columns()) {
                wp_enqueue_style('pac_drh_col_numbering_css', plugins_url("/includes/assets/public/css/column-numbering$min.css", PAC_DRH_FILE), [], PAC_DRH_VERSION);
            }
            if (pac_drh_enable_blog_number_of_columns()) {
                wp_enqueue_style('pac_drh_et_pb_blog_css', plugins_url("/includes/assets/public/css/et-pb-blog$min.css", PAC_DRH_FILE), [], PAC_DRH_VERSION);
            }
            if (pac_drh_enable_portfolio_number_of_columns()) {
                wp_enqueue_style('pac_drh_et_pb_portfolio_css', plugins_url("/includes/assets/public/css/et-pb-portfolio$min.css", PAC_DRH_FILE), [], PAC_DRH_VERSION);
            }
            if (pac_drh_enable_gallery_number_of_columns()) {
                wp_enqueue_style('pac_drh_et_pb_gallery_css', plugins_url("/includes/assets/public/css/et-pb-gallery$min.css", PAC_DRH_FILE), [], PAC_DRH_VERSION);
            }
            if (pac_drh_enable_shop_number_of_columns()) {
                wp_enqueue_style('pac_drh_et_pb_shop_css', plugins_url("/includes/assets/public/css/et-pb-shop$min.css", PAC_DRH_FILE), [], PAC_DRH_VERSION);
            }
            if (pac_drh_enable_mobile_parallax()) {
                wp_enqueue_script('pac_drh_mobile_parallax', plugins_url("/includes/assets/public/js/mobile-parallax$min.js", PAC_DRH_FILE), [], PAC_DRH_VERSION, true);
            }
            if (pac_drh_enable_view_port_size()) {
                wp_enqueue_script('pac_drh_viewport', plugins_url("/includes/assets/admin/js/viewport$min.js", PAC_DRH_FILE), ["jquery"], PAC_DRH_VERSION, true);
                wp_localize_script('pac_drh_viewport', 'pac_drh_vp_obj', ['is_admin' => is_admin()]);
            }
        }

        add_action('wp_enqueue_scripts', 'pac_drh_enqueue_scripts');
    }

    add_action('init', 'pac_drh_if_user_logged_in');
}
/**
 * Public Scripts
 *
 * @param $hook
 */
if (!function_exists('pac_drh_admin_enqueue_scripts')) {
    function pac_drh_admin_enqueue_scripts($hook)
    {
        $divi_ghoster = is_plugin_active('divi-ghoster/divi-ghoster.php');
        $allowed_pages = [
            'edit.php',
            'toplevel_page_et_divi_options',
            'divi_page_et_theme_builder',
            'extra_page_et_theme_builder',
            'toplevel_page_et_extra_options',
        ];
        if ($divi_ghoster) {
            $divi_ghoster_options = get_option('agsdg_settings');
            $divi_ghoster_theme_slug = isset($divi_ghoster_options['theme_slug']) ? $divi_ghoster_options['theme_slug'] : '';
            $allowed_pages = array_merge($allowed_pages, ["toplevel_page_et_".$divi_ghoster_theme_slug."_options"]);
        }
        if (!in_array($hook, $allowed_pages, true)) {
            return;
        }
        $min = pac_drh_minify();
        wp_enqueue_script('pac_drh_dashboard', plugins_url("/includes/assets/admin/js/epanel$min.js", PAC_DRH_FILE));
        if (pac_drh_enable_auto_responsive()) {
            wp_enqueue_script('pac_drh_vb_responsive', plugins_url("/includes/assets/admin/js/responsive-tabs$min.js", PAC_DRH_FILE), [], PAC_DRH_VERSION, true);
            wp_localize_script('pac_drh_vb_responsive', 'pac_drh_vb_obj', ['responsiveTabs' => 'on']);
        }
        if (pac_drh_enable_presets() || pac_drh_enable_custom_preview()) {
            wp_enqueue_script('pac_drh_vb_responsive_buttons', plugins_url("/includes/assets/admin/js/presets$min.js", PAC_DRH_FILE), ["jquery"], PAC_DRH_VERSION, true);
            wp_localize_script('pac_drh_vb_responsive_buttons', 'pac_drh_custom_presets', pac_drh_custom_presets());
            wp_enqueue_style('pac_drh_responsive_settings_vb_css', plugins_url('/includes/assets/admin/css/style.css', PAC_DRH_FILE));
        }
        wp_enqueue_script('pac_drh_custom_media_query', plugins_url("/includes/assets/admin/js/media-query$min.js", PAC_DRH_FILE), [], PAC_DRH_VERSION, true);
        if (pac_drh_enable_view_port_size()) {
            wp_enqueue_script('pac_drh_viewport', plugins_url("/includes/assets/admin/js/viewport$min.js", PAC_DRH_FILE), ["jquery"], PAC_DRH_VERSION, true);
            wp_localize_script('pac_drh_viewport', 'pac_drh_vp_obj', ['is_admin' => is_admin()]);
        }
    }

    add_action('admin_enqueue_scripts', 'pac_drh_admin_enqueue_scripts');
    add_action('admin_enqueue_scripts', 'pac_drh_enqueue_scripts');
}
// Include Required Features
if (!function_exists('pac_drh_init_plugin')) {
    function pac_drh_init_plugin()
    {
        /**
         * ePanel Settings
         *
         * {@see pac_drh_epanel_tabs()} function.
         * {@see pac_drh_epanel_fields()} function.
         * {@see pac_drh_et_core_portability()} function.
         */
        require_once PAC_DRH_PATH.'/includes/admin/epanel/epanel.php';
        /**
         * Mobile Detect Class
         */
        require_once PAC_DRH_PATH."/includes/lib/Mobile_Detect.php";
        /**
         * Custom Media Quries
         *
         * {@see pac_drh_media_queries_css()} function.
         * {@see pac_drh_custom_media_queries_css()} function.
         */
        require_once PAC_DRH_PATH.'/includes/admin/drh-settings/media-query.php';
        /**
         * Miscellaneous
         *
         * {@see pac_drh_disabled_animation_css()} function.
         * {@see pac_drh_disabled_animation_js()} function.
         * {@see pac_drh_backtotop_visibility_css()} function.
         * {@see pac_drh_prevent_horizontal_scroll_css()} function.
         * {@see pac_drh_add_mobile_logo()} function.
         * {@see pac_drh_change_mobile_header_color()} function.
         * {@see pac_drh_mobile_pinch_zoom()} function.
         * {@see pac_drh_disabled_hover_effects()} function.
         * {@see pac_drh_presets_settings()} function.
         * {@see pac_drh_hide_divi_responsive_views()} function.
         */
        require_once PAC_DRH_PATH.'/includes/admin/drh-settings/miscellaneous.php';
        /**
         * Header Menu
         *
         * {@see pac_drh_menu_hamburger_with_text()} function.
         * {@see pac_drh_header_hamburger_menu()} function.
         * {@see pac_drh_opened_menu_icon()} function.
         * {@see pac_drh_make_navigation_bar_fixed()} function.
         * {@see pac_drh_change_phone_menu_breakpoint()} function.
         * {@see pac_drh_collapse_mobile_submenus()} function.
         */
        require_once PAC_DRH_PATH.'/includes/admin/drh-settings/header-menu.php';
        /**
         * Customizer
         *
         * {@see pac_drh_update_customizer_values()} function.
         */
        require_once PAC_DRH_PATH.'/includes/admin/drh-settings/customizer-options.php';
        /**
         * Layout Module
         *
         * {@see pac_drh_row_layout_fields()} function.
         * {@see pac_drh_row_layout_output()} function.
         */
        require_once PAC_DRH_PATH.'/includes/admin/modules/et-pb-row-layout.php';
        /**
         * Menu Module
         *
         * {@see pac_drh_filter_menu_fields()} function.
         * {@see pac_drh_filter_menu_props()} function.
         * {@see pac_drh_filter_menu_output()} function.
         * {@see pac_drh_collapse_mobile_menu_js()} function.
         */
        if (pac_drh_enable_menu_module_settings()) {
            require_once PAC_DRH_PATH.'/includes/admin/modules/et-pb-menu.php';
        }
        /**
         * Row Module
         *
         * {@see pac_drh_add_class_to_row()} function.
         */
        if (pac_drh_enable_number_of_columns() || pac_drh_enable_col_stacking()) {
            require_once PAC_DRH_PATH.'/includes/admin/modules/et-pb-row.php';
        }
        /**
         * Column Module
         *
         * {@see pac_drh_add_class_to_column()} function.
         */
        if (pac_drh_enable_col_stacking()) {
            require_once PAC_DRH_PATH.'/includes/admin/modules/et-pb-column.php';
        }
        /**
         * Gallery Module
         *
         * {@see pac_drh_filter_gallery_fields()} function.
         * {@see pac_drh_filter_gallery_props()} function.
         * {@see pac_drh_filter_gallery_output()} function.
         */
        require_once PAC_DRH_PATH.'/includes/admin/modules/et-pb-gallery.php';
        /**
         * Blog Module
         *
         * {@see pac_drh_filter_blog_fields()} function.
         * {@see pac_drh_filter_blog_props()} function.
         * {@see pac_drh_filter_blog_output()} function.
         */
        require_once PAC_DRH_PATH.'/includes/admin/modules/et-pb-blog.php';
        /**
         * Woo Products Module
         *
         * {@see pac_drh_filter_shop_fields()} function.
         * {@see pac_drh_filter_shop_props()} function.
         * {@see pac_drh_filter_shop_output()} function.
         */
        require_once PAC_DRH_PATH.'/includes/admin/modules/et-pb-shop.php';
        /**
         * Portfolio Module
         *
         * {@see pac_drh_filter_portfolio_fields()} function.
         * {@see pac_drh_filter_portfolio_props()} function.
         * {@see pac_drh_filter_portfolio_output()} function.
         */
        require_once PAC_DRH_PATH.'/includes/admin/modules/et-pb-portfolio.php';
        /**
         * Blurb Module
         *
         * {@see pac_drh_filter_blurb_fields()} function.
         * {@see pac_drh_filter_blurb_output()} function.
         * {@see pac_drh_blurb_css()} function.
         */
        if (pac_drh_enable_blurb_settings()) {
            require_once PAC_DRH_PATH.'/includes/admin/modules/et-pb-blurb.php';
        }
        /**
         * Tab Module
         *
         * {@see pac_drh_filter_tabs_fields()} function.
         * {@see pac_drh_filter_tab_output()} function.
         * {@see pac_drh_tabs_css()} function.
         */
        if (pac_drh_enable_tabs_layout_settings()) {
            require_once PAC_DRH_PATH.'/includes/admin/modules/et-pb-tabs.php';
        }
        /**
         * Widow Fixer
         *
         * {@see pac_drh_widow_fixer()} function.
         */
        if (pac_drh_enable_widow_fixer()) {
            require_once PAC_DRH_PATH.'/includes/admin/drh-settings/widow-fixer.php';
        }
        /**
         * Column Stacking
         *
         * {@see pac_drh_add_staking_toggle()} function.
         * {@see pac_drh_filter_column_fields()} function.
         */
        if (pac_drh_enable_col_stacking()) {
            require_once PAC_DRH_PATH.'/includes/admin/drh-settings/col-stacking.php';
        }
        /**
         * Column Numbers
         *
         * {@see pac_drh_add_col_numbering_options()} function.
         */
        if (pac_drh_enable_number_of_columns()) {
            require_once PAC_DRH_PATH.'/includes/admin/drh-settings/col-numbers.php';
        }
        /**
         * Typography
         *
         * {@see pac_drh_typography()} function.
         */
        if (pac_drh_enable_text_sizes()) {
            require_once PAC_DRH_PATH.'/includes/admin/drh-settings/typography.php';
        }
        /**
         * WP Nav Filters
         *
         * {@see pac_drh_menu_item_custom_fields()} function.
         * {@see pac_drh_update_menu_item()} function.
         * {@see pac_drh_menu_css_class()} function.
         * {@see pac_drh_menu_css()} function.
         */
        if (pac_drh_enable_show_hide_menu_item()) {
            require_once PAC_DRH_PATH.'/includes/admin/drh-settings/wordpress-navigation-filters.php';
        }
        /**
         * Related Products Module
         *
         * {@see pac_drh_filter_related_products_fields()} function.
         * {@see pac_drh_filter_related_products_output()} function.
         */
        if (pac_drh_enable_related_products_number_of_columns()) {
            require_once PAC_DRH_PATH.'/includes/admin/modules/et-pb-related-products.php';
        }
        /**
         * CrossSells Products Module
         *
         * {@see pac_drh_filter_crosssells_toggles()} function.
         * {@see pac_drh_filter_crosssells_fields()} function.
         * {@see pac_drh_filter_crosssells_output()} function.
         */
        if (pac_drh_enable_crosssells_number_of_columns()) {
            require_once PAC_DRH_PATH.'/includes/admin/modules/et-pb-cross-sells-products.php';
        }
        /**
         * UpSells Products Module
         *
         * {@see pac_drh_filter_upsells_fields()} function.
         * {@see pac_drh_filter_upsells_output()} function.
         */
        if (pac_drh_enable_upsells_number_of_columns()) {
            require_once PAC_DRH_PATH.'/includes/admin/modules/et-pb-up-sells-products.php';
        }
        /**
         * Custome Gutter Width
         *
         * {@see pac_drh_filter_row_fields()} function.
         * {@see pac_drh_filter_row_output()} function.
         */
        if (pac_drh_enable_custom_gutter_width()) {
            require_once PAC_DRH_PATH.'/includes/admin/modules/et-pb-custom-gutter.php';
        }
    }

    add_action('init', 'pac_drh_init_plugin');
}